/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.openid.controller;

import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdConfiguration;

public abstract class TokenClaimsSetVerifier
implements JWTClaimsSetVerifier {
    protected final OpenIdConfiguration configuration;

    public TokenClaimsSetVerifier(OpenIdConfiguration configuration) {
        this.configuration = configuration;
    }

    public void verify(JWTClaimsSet claims, SecurityContext c) throws BadJWTException {
        StandardVerifications standardVerifications = new StandardVerifications(this.configuration, claims);
        standardVerifications.requireSameIssuer();
        standardVerifications.requireSubject();
        standardVerifications.requireAudience(this.configuration.getClientId());
        standardVerifications.assureAuthorizedParty(this.configuration.getClientId());
        standardVerifications.requireValidTimestamp();
        this.verify(claims);
    }

    public abstract void verify(JWTClaimsSet var1) throws BadJWTException;

    protected static class StandardVerifications {
        private final OpenIdConfiguration configuration;
        private final JWTClaimsSet claims;

        public StandardVerifications(OpenIdConfiguration configuration, JWTClaimsSet claims) {
            this.configuration = configuration;
            this.claims = claims;
        }

        public void requireSameIssuer() {
            if (Objects.isNull(this.claims.getIssuer())) {
                throw new IllegalStateException("Missing issuer (iss) claim");
            }
            if (!this.claims.getIssuer().equals(this.configuration.getProviderMetadata().getIssuerURI())) {
                throw new IllegalStateException("Invalid issuer : " + this.configuration.getProviderMetadata().getIssuerURI());
            }
        }

        public void requireSubject() {
            if (Objects.isNull(this.claims.getSubject())) {
                throw new IllegalStateException("Missing subject (sub) claim");
            }
        }

        public void requireAudience(String requiredAudience) {
            List<String> audience = this.claims.getAudience();
            if (Objects.isNull(audience) || audience.isEmpty()) {
                throw new IllegalStateException("Missing audience (aud) claim");
            }
            if (requiredAudience != null && !audience.contains(requiredAudience)) {
                throw new IllegalStateException("Invalid audience (aud) claim " + audience);
            }
        }

        public void assureAuthorizedParty(String clientId) {
            Object authorizedParty = this.claims.getClaim("azp");
            List<String> audience = this.claims.getAudience();
            if (audience.size() > 1 && Objects.isNull(authorizedParty)) {
                throw new IllegalStateException("Missing authorized party (azp) claim");
            }
            if (audience.size() > 1 && !authorizedParty.equals(clientId)) {
                throw new IllegalStateException("Invalid authorized party (azp) claim " + authorizedParty);
            }
        }

        public void requireValidTimestamp() {
            long clockSkewInMillis = TimeUnit.MINUTES.toMillis(1L);
            long currentTime = System.currentTimeMillis();
            Date exp = this.claims.getExpirationTime();
            if (Objects.isNull(exp)) {
                throw new IllegalStateException("Missing expiration time (exp) claim");
            }
            if (exp.getTime() + clockSkewInMillis < currentTime) {
                throw new IllegalStateException("Token is expired " + exp);
            }
            Date iat = this.claims.getIssueTime();
            if (Objects.isNull(iat)) {
                throw new IllegalStateException("Missing issue time (iat) claim");
            }
            if (iat.getTime() - clockSkewInMillis > currentTime) {
                throw new IllegalStateException("Issue time must be after current time " + iat);
            }
            Date nbf = this.claims.getNotBeforeTime();
            if (!Objects.isNull(nbf) && nbf.getTime() - clockSkewInMillis > currentTime) {
                throw new IllegalStateException("Token is not valid before " + nbf);
            }
        }
    }
}

