/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.openid.controller;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import jakarta.security.enterprise.identitystore.openid.IdentityToken;
import java.util.List;
import java.util.Objects;
import org.glassfish.soteria.mechanisms.openid.controller.TokenClaimsSetVerifier;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdConfiguration;

public class RefreshedIdTokenClaimsSetVerifier
extends TokenClaimsSetVerifier {
    private final IdentityToken previousIdToken;

    public RefreshedIdTokenClaimsSetVerifier(IdentityToken previousIdToken, OpenIdConfiguration configuration) {
        super(configuration);
        this.previousIdToken = previousIdToken;
    }

    @Override
    public void verify(JWTClaimsSet claims) throws BadJWTException {
        String previousIssuer = this.previousIdToken.getJwtClaims().getIssuer().orElse(null);
        String newIssuer = claims.getIssuer();
        if (newIssuer == null || !newIssuer.equals(previousIssuer)) {
            throw new IllegalStateException("iss Claim Value MUST be the same as in the ID Token issued when the original authentication occurred.");
        }
        String previousSubject = this.previousIdToken.getJwtClaims().getSubject().orElse(null);
        String newSubject = claims.getSubject();
        if (newSubject == null || !newSubject.equals(previousSubject)) {
            throw new IllegalStateException("sub Claim Value MUST be the same as in the ID Token issued when the original authentication occurred.");
        }
        List<String> previousAudience = this.previousIdToken.getJwtClaims().getAudience();
        List<String> newAudience = claims.getAudience();
        if (newAudience == null || !newAudience.equals(previousAudience)) {
            throw new IllegalStateException("aud Claim Value MUST be the same as in the ID Token issued when the original authentication occurred.");
        }
        if (Objects.isNull(claims.getIssueTime())) {
            throw new IllegalStateException("iat Claim Value must not be null.");
        }
        String previousAzp = (String)this.previousIdToken.getClaims().get("azp");
        String newAzp = (String)claims.getClaim("azp");
        if (previousAzp == null ? newAzp != null : !previousAzp.equals(newAzp)) {
            throw new IllegalStateException("azp Claim Value MUST be the same as in the ID Token issued when the original authentication occurred.");
        }
    }
}

