/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.cdi;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.interceptor.Interceptor;
import jakarta.security.enterprise.authentication.mechanism.http.AutoApplySession;
import jakarta.security.enterprise.authentication.mechanism.http.BasicAuthenticationMechanismDefinition;
import jakarta.security.enterprise.authentication.mechanism.http.CustomFormAuthenticationMechanismDefinition;
import jakarta.security.enterprise.authentication.mechanism.http.FormAuthenticationMechanismDefinition;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanismHandler;
import jakarta.security.enterprise.authentication.mechanism.http.LoginToContinue;
import jakarta.security.enterprise.authentication.mechanism.http.OpenIdAuthenticationMechanismDefinition;
import jakarta.security.enterprise.authentication.mechanism.http.RememberMe;
import jakarta.security.enterprise.identitystore.DatabaseIdentityStoreDefinition;
import jakarta.security.enterprise.identitystore.IdentityStore;
import jakarta.security.enterprise.identitystore.IdentityStoreHandler;
import jakarta.security.enterprise.identitystore.InMemoryIdentityStoreDefinition;
import jakarta.security.enterprise.identitystore.LdapIdentityStoreDefinition;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.glassfish.soteria.SecurityContextImpl;
import org.glassfish.soteria.SoteriaServiceProviders;
import org.glassfish.soteria.Utils;
import org.glassfish.soteria.cdi.AutoApplySessionInterceptor;
import org.glassfish.soteria.cdi.BasicAuthenticationMechanismDefinitionAnnotationLiteral;
import org.glassfish.soteria.cdi.CdiProducer;
import org.glassfish.soteria.cdi.CdiUtils;
import org.glassfish.soteria.cdi.DatabaseIdentityStoreDefinitionAnnotationLiteral;
import org.glassfish.soteria.cdi.DefaultIdentityStoreHandler;
import org.glassfish.soteria.cdi.LdapIdentityStoreDefinitionAnnotationLiteral;
import org.glassfish.soteria.cdi.LoginToContinueAnnotationLiteral;
import org.glassfish.soteria.cdi.LoginToContinueInterceptor;
import org.glassfish.soteria.cdi.RememberMeInterceptor;
import org.glassfish.soteria.cdi.spi.BeanDecorator;
import org.glassfish.soteria.cdi.spi.WebXmlLoginConfig;
import org.glassfish.soteria.identitystores.DatabaseIdentityStore;
import org.glassfish.soteria.identitystores.InMemoryIdentityStore;
import org.glassfish.soteria.identitystores.LdapIdentityStore;
import org.glassfish.soteria.identitystores.hash.Pbkdf2PasswordHashImpl;
import org.glassfish.soteria.mechanisms.BasicAuthenticationMechanism;
import org.glassfish.soteria.mechanisms.CustomFormAuthenticationMechanism;
import org.glassfish.soteria.mechanisms.DefaultHttpAuthenticationMechanismHandler;
import org.glassfish.soteria.mechanisms.FormAuthenticationMechanism;
import org.glassfish.soteria.mechanisms.OpenIdAuthenticationMechanism;
import org.glassfish.soteria.mechanisms.openid.OpenIdIdentityStore;
import org.glassfish.soteria.mechanisms.openid.controller.AuthenticationController;
import org.glassfish.soteria.mechanisms.openid.controller.ConfigurationController;
import org.glassfish.soteria.mechanisms.openid.controller.JWTValidator;
import org.glassfish.soteria.mechanisms.openid.controller.NonceController;
import org.glassfish.soteria.mechanisms.openid.controller.ProviderMetadataController;
import org.glassfish.soteria.mechanisms.openid.controller.StateController;
import org.glassfish.soteria.mechanisms.openid.controller.TokenController;
import org.glassfish.soteria.mechanisms.openid.controller.UserInfoController;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdContextImpl;

public class CdiExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(CdiExtension.class.getName());
    private List<Bean<IdentityStore>> identityStoreBeans = new ArrayList<Bean<IdentityStore>>();
    private List<Bean<HttpAuthenticationMechanism>> authenticationMechanismBeans = new ArrayList<Bean<HttpAuthenticationMechanism>>();
    private List<Bean<?>> extraBeans = new ArrayList();
    private boolean httpAuthenticationMechanismFound;

    public void register(@Observes BeforeBeanDiscovery beforeBean, BeanManager beanManager) {
        CdiUtils.addAnnotatedTypes(beforeBean, beanManager, AutoApplySessionInterceptor.class, RememberMeInterceptor.class, LoginToContinueInterceptor.class, FormAuthenticationMechanism.class, CustomFormAuthenticationMechanism.class, SecurityContextImpl.class, IdentityStoreHandler.class, Pbkdf2PasswordHashImpl.class, AuthenticationController.class, ConfigurationController.class, NonceController.class, ProviderMetadataController.class, StateController.class, TokenController.class, UserInfoController.class, OpenIdContextImpl.class, OpenIdIdentityStore.class, OpenIdAuthenticationMechanism.class, JWTValidator.class);
    }

    public <T> void processBean(@Observes ProcessBean<T> eventIn, BeanManager beanManager) {
        ProcessBean<T> event = eventIn;
        Class<?> beanClass = event.getBean().getBeanClass();
        Optional<InMemoryIdentityStoreDefinition> optionalInMemoryStore = CdiUtils.getAnnotation(beanManager, event.getAnnotated(), InMemoryIdentityStoreDefinition.class);
        optionalInMemoryStore.ifPresent(inMemoryIdentityStoreDefinition -> {
            this.logActivatedIdentityStore(InMemoryIdentityStore.class, beanClass);
            this.identityStoreBeans.add(new CdiProducer().scope(ApplicationScoped.class).types(new Type[]{Object.class, IdentityStore.class, InMemoryIdentityStore.class}).addToId(InMemoryIdentityStoreDefinition.class).create(e -> new InMemoryIdentityStore((InMemoryIdentityStoreDefinition)inMemoryIdentityStoreDefinition)));
        });
        Optional<DatabaseIdentityStoreDefinition> optionalDBStore = CdiUtils.getAnnotation(beanManager, event.getAnnotated(), DatabaseIdentityStoreDefinition.class);
        optionalDBStore.ifPresent(dataBaseIdentityStoreDefinition -> {
            this.logActivatedIdentityStore(DatabaseIdentityStoreDefinition.class, beanClass);
            this.identityStoreBeans.add(new CdiProducer().scope(ApplicationScoped.class).types(new Type[]{Object.class, IdentityStore.class, DatabaseIdentityStore.class}).addToId(DatabaseIdentityStoreDefinition.class).create(e -> new DatabaseIdentityStore(DatabaseIdentityStoreDefinitionAnnotationLiteral.eval(dataBaseIdentityStoreDefinition))));
        });
        Optional<LdapIdentityStoreDefinition> optionalLdapStore = CdiUtils.getAnnotation(beanManager, event.getAnnotated(), LdapIdentityStoreDefinition.class);
        optionalLdapStore.ifPresent(ldapIdentityStoreDefinition -> {
            this.logActivatedIdentityStore(LdapIdentityStoreDefinition.class, beanClass);
            this.identityStoreBeans.add(new CdiProducer().scope(ApplicationScoped.class).types(new Type[]{Object.class, IdentityStore.class, LdapIdentityStore.class}).addToId(LdapIdentityStoreDefinition.class).create(e -> new LdapIdentityStore(LdapIdentityStoreDefinitionAnnotationLiteral.eval(ldapIdentityStoreDefinition))));
        });
        CdiUtils.getAnnotation(beanManager, event.getAnnotated(), BasicAuthenticationMechanismDefinition.List.class).ifPresent(list -> {
            for (BasicAuthenticationMechanismDefinition basicAuthenticationMechanismDefinition : list.value()) {
                this.createBasicAuthenticationMechanismBean(basicAuthenticationMechanismDefinition, beanClass);
            }
        });
        CdiUtils.getAnnotation(beanManager, event.getAnnotated(), BasicAuthenticationMechanismDefinition.class).ifPresent(basicAuthenticationMechanismDefinition -> this.createBasicAuthenticationMechanismBean((BasicAuthenticationMechanismDefinition)basicAuthenticationMechanismDefinition, beanClass));
        CdiUtils.getAnnotation(beanManager, event.getAnnotated(), FormAuthenticationMechanismDefinition.List.class).ifPresent(list -> {
            for (FormAuthenticationMechanismDefinition formAuthenticationMechanismDefinition : list.value()) {
                this.createFormAuthenticationMechanismBean(formAuthenticationMechanismDefinition, beanClass);
            }
        });
        CdiUtils.getAnnotation(beanManager, event.getAnnotated(), FormAuthenticationMechanismDefinition.class).ifPresent(formAuthenticationMechanismDefinition -> this.createFormAuthenticationMechanismBean((FormAuthenticationMechanismDefinition)formAuthenticationMechanismDefinition, beanClass));
        CdiUtils.getAnnotation(beanManager, event.getAnnotated(), CustomFormAuthenticationMechanismDefinition.List.class).ifPresent(list -> {
            for (CustomFormAuthenticationMechanismDefinition customFormAuthenticationMechanismDefinition : list.value()) {
                this.createCustomFormAuthenticationMechanismBean(customFormAuthenticationMechanismDefinition, beanClass);
            }
        });
        CdiUtils.getAnnotation(beanManager, event.getAnnotated(), CustomFormAuthenticationMechanismDefinition.class).ifPresent(customFormAuthenticationMechanismDefinition -> this.createCustomFormAuthenticationMechanismBean((CustomFormAuthenticationMechanismDefinition)customFormAuthenticationMechanismDefinition, beanClass));
        Optional<OpenIdAuthenticationMechanismDefinition> opentionalOpenIdMechanism = CdiUtils.getAnnotation(beanManager, event.getAnnotated(), OpenIdAuthenticationMechanismDefinition.class);
        opentionalOpenIdMechanism.ifPresent(definition -> {
            this.logActivatedAuthenticationMechanism(OpenIdAuthenticationMechanismDefinition.class, beanClass);
            this.validateOpenIdParametersFormat((OpenIdAuthenticationMechanismDefinition)definition);
            this.authenticationMechanismBeans.add(new CdiProducer().scope(ApplicationScoped.class).types(new Type[]{HttpAuthenticationMechanism.class}).qualifiers(this.createAnnotationInstances(definition.qualifiers())).addToId(OpenIdAuthenticationMechanism.class).create(e -> CdiUtils.getBeanReference(OpenIdAuthenticationMechanism.class, new Annotation[0])));
            this.identityStoreBeans.add(new CdiProducer().scope(ApplicationScoped.class).types(new Type[]{IdentityStore.class}).addToId(OpenIdIdentityStore.class).create(e -> CdiUtils.getBeanReference(OpenIdIdentityStore.class, new Annotation[0])));
            this.extraBeans.add(new CdiProducer().scope(ApplicationScoped.class).types(new Type[]{OpenIdAuthenticationMechanismDefinition.class}).addToId("OpenId Definition").create(e -> definition));
        });
        if (event.getBean().getTypes().contains(HttpAuthenticationMechanism.class)) {
            this.httpAuthenticationMechanismFound = true;
        }
        this.checkForWrongUseOfInterceptors(event.getAnnotated(), beanClass);
    }

    private void createBasicAuthenticationMechanismBean(BasicAuthenticationMechanismDefinition basicAuthenticationMechanismDefinition, Class<?> beanClass) {
        this.logActivatedAuthenticationMechanism(BasicAuthenticationMechanismDefinition.class, beanClass);
        this.authenticationMechanismBeans.add(new CdiProducer().scope(ApplicationScoped.class).types(new Type[]{Object.class, HttpAuthenticationMechanism.class, BasicAuthenticationMechanism.class}).qualifiers(this.createAnnotationInstances(basicAuthenticationMechanismDefinition.qualifiers())).addToId(BasicAuthenticationMechanismDefinition.class + this.toString(basicAuthenticationMechanismDefinition.qualifiers())).create(e -> new BasicAuthenticationMechanism(BasicAuthenticationMechanismDefinitionAnnotationLiteral.eval(basicAuthenticationMechanismDefinition))));
    }

    private String toString(Class<?>[] qualifiers) {
        return Arrays.stream(qualifiers).map(Object::toString).collect(Collectors.joining(", "));
    }

    private void createFormAuthenticationMechanismBean(FormAuthenticationMechanismDefinition formAuthenticationMechanismDefinition, Class<?> beanClass) {
        this.logActivatedAuthenticationMechanism(FormAuthenticationMechanismDefinition.class, beanClass);
        this.authenticationMechanismBeans.add(new CdiProducer().scope(ApplicationScoped.class).types(new Type[]{Object.class, HttpAuthenticationMechanism.class}).qualifiers(this.createAnnotationInstances(formAuthenticationMechanismDefinition.qualifiers())).addToId(FormAuthenticationMechanismDefinition.class).create(e -> {
            FormAuthenticationMechanism authMethod = CdiUtils.getBeanReference(FormAuthenticationMechanism.class, new Annotation[0]);
            authMethod.setLoginToContinue(LoginToContinueAnnotationLiteral.eval(formAuthenticationMechanismDefinition.loginToContinue()));
            return authMethod;
        }));
    }

    private void createCustomFormAuthenticationMechanismBean(CustomFormAuthenticationMechanismDefinition customFormAuthenticationMechanismDefinition, Class<?> beanClass) {
        this.logActivatedAuthenticationMechanism(CustomFormAuthenticationMechanismDefinition.class, beanClass);
        this.authenticationMechanismBeans.add(new CdiProducer().scope(ApplicationScoped.class).types(new Type[]{Object.class, HttpAuthenticationMechanism.class}).qualifiers(this.createAnnotationInstances(customFormAuthenticationMechanismDefinition.qualifiers())).addToId(CustomFormAuthenticationMechanismDefinition.class).create(e -> {
            CustomFormAuthenticationMechanism authMethod = CdiUtils.getBeanReference(CustomFormAuthenticationMechanism.class, new Annotation[0]);
            authMethod.setLoginToContinue(LoginToContinueAnnotationLiteral.eval(customFormAuthenticationMechanismDefinition.loginToContinue()));
            return authMethod;
        }));
    }

    private void createOpenIdAuthenticationMechanismBean(OpenIdAuthenticationMechanismDefinition openIdAuthenticationMechanismDefinition, Class<?> beanClass) {
    }

    public void afterBean(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        BeanDecorator decorator = SoteriaServiceProviders.getServiceProvider(BeanDecorator.class);
        WebXmlLoginConfig loginConfig = SoteriaServiceProviders.getServiceProvider(WebXmlLoginConfig.class);
        if (!this.identityStoreBeans.isEmpty()) {
            for (Bean<IdentityStore> bean : this.identityStoreBeans) {
                afterBeanDiscovery.addBean(decorator.decorateBean(bean, IdentityStore.class, beanManager));
            }
        }
        if (this.authenticationMechanismBeans.isEmpty() && loginConfig.getAuthMethod() != null) {
            if ("basic".equalsIgnoreCase(loginConfig.getAuthMethod())) {
                this.authenticationMechanismBeans.add(new CdiProducer().scope(ApplicationScoped.class).types(new Type[]{Object.class, HttpAuthenticationMechanism.class, BasicAuthenticationMechanism.class}).addToId(BasicAuthenticationMechanismDefinition.class).create(e -> new BasicAuthenticationMechanism(new BasicAuthenticationMechanismDefinitionAnnotationLiteral(loginConfig.getRealmName()))));
                this.httpAuthenticationMechanismFound = true;
            } else if ("form".equalsIgnoreCase(loginConfig.getAuthMethod())) {
                this.authenticationMechanismBeans.add(new CdiProducer().scope(ApplicationScoped.class).types(new Type[]{Object.class, HttpAuthenticationMechanism.class}).addToId(FormAuthenticationMechanismDefinition.class).create(e -> {
                    FormAuthenticationMechanism authMethod = CdiUtils.getBeanReference(FormAuthenticationMechanism.class, new Annotation[0]);
                    authMethod.setLoginToContinue(new LoginToContinueAnnotationLiteral(loginConfig.getFormLoginPage(), true, null, loginConfig.getFormErrorPage()));
                    return authMethod;
                }));
                this.httpAuthenticationMechanismFound = true;
            }
        }
        if (!this.authenticationMechanismBeans.isEmpty()) {
            for (Bean<Object> bean : this.authenticationMechanismBeans) {
                afterBeanDiscovery.addBean(decorator.decorateBean(bean, HttpAuthenticationMechanism.class, beanManager));
            }
        }
        for (Bean<Object> bean : this.extraBeans) {
            afterBeanDiscovery.addBean(bean);
        }
        if (this.extraBeans.isEmpty()) {
            afterBeanDiscovery.addBean().scope(Dependent.class).types(new Type[]{OpenIdAuthenticationMechanismDefinition.class}).id("Null OpenId Definition").createWith(cc -> null);
        }
        afterBeanDiscovery.addBean(decorator.decorateBean(new CdiProducer().scope(ApplicationScoped.class).types(new Type[]{Object.class, IdentityStoreHandler.class}).addToId(IdentityStoreHandler.class).create(e -> {
            DefaultIdentityStoreHandler defaultIdentityStoreHandler = new DefaultIdentityStoreHandler();
            defaultIdentityStoreHandler.init();
            return defaultIdentityStoreHandler;
        }), IdentityStoreHandler.class, beanManager));
        afterBeanDiscovery.addBean(decorator.decorateBean(new CdiProducer().scope(ApplicationScoped.class).types(new Type[]{Object.class, HttpAuthenticationMechanismHandler.class}).addToId(IdentityStoreHandler.class).create(e -> {
            DefaultHttpAuthenticationMechanismHandler defaultHttpAuthenticationMechanismHandler = new DefaultHttpAuthenticationMechanismHandler();
            defaultHttpAuthenticationMechanismHandler.init();
            return defaultHttpAuthenticationMechanismHandler;
        }), HttpAuthenticationMechanismHandler.class, beanManager));
    }

    public boolean isHttpAuthenticationMechanismFound() {
        return this.httpAuthenticationMechanismFound;
    }

    private Annotation[] createAnnotationInstances(Class<?> ... types) {
        Annotation[] instances = null;
        if (types.length == 0) {
            instances = (Annotation[])Array.newInstance(Annotation.class, 2);
            instances[0] = Default.Literal.INSTANCE;
            instances[1] = Any.Literal.INSTANCE;
            return instances;
        }
        instances = Utils.createAnnotationInstances(types);
        if (!this.containsAny(types)) {
            Annotation[] instancesNew = (Annotation[])Array.newInstance(Annotation.class, types.length + 1);
            System.arraycopy(instances, 0, instancesNew, 0, instances.length);
            instances = instancesNew;
            instances[types.length] = Any.Literal.INSTANCE;
        }
        return instances;
    }

    private boolean containsAny(Class<?> ... types) {
        for (Class<?> type2 : types) {
            if (!type2.equals(Any.class)) continue;
            return true;
        }
        return false;
    }

    private void logActivatedIdentityStore(Class<?> identityStoreClass, Class<?> beanClass) {
        LOGGER.log(Level.INFO, "Activating {0} identity store from {1} class", new Object[]{identityStoreClass.getName(), beanClass.getName()});
    }

    private void logActivatedAuthenticationMechanism(Class<?> authenticationMechanismClass, Class<?> beanClass) {
        LOGGER.log(Level.INFO, "Activating {0} authentication mechanism from {1} class", new Object[]{authenticationMechanismClass.getName(), beanClass.getName()});
    }

    private void checkForWrongUseOfInterceptors(Annotated annotated, Class<?> beanClass) {
        List<Class> annotations = Arrays.asList(AutoApplySession.class, LoginToContinue.class, RememberMe.class);
        for (Class annotation : annotations) {
            if (!annotated.isAnnotationPresent(annotation) || annotated.isAnnotationPresent(Interceptor.class) || HttpAuthenticationMechanism.class.isAssignableFrom(beanClass)) continue;
            LOGGER.log(Level.WARNING, "Only classes implementing {0} may be annotated with {1}. {2} is annotated, but the interceptor won't take effect on it.", new Object[]{HttpAuthenticationMechanism.class.getName(), annotation.getName(), beanClass.getName()});
        }
    }

    private void validateOpenIdParametersFormat(OpenIdAuthenticationMechanismDefinition definition) {
        for (String extraParameter : definition.extraParameters()) {
            String[] parts = extraParameter.split("=");
            if (parts.length == 2) continue;
            throw new DefinitionException(OpenIdAuthenticationMechanismDefinition.class.getSimpleName() + ".extraParameters() value '" + extraParameter + "' is not of the format key=value");
        }
    }
}

