/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.server;

import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.main.jdke.props.SystemProperties;
import org.jvnet.hk2.annotations.Service;

@Service
public class ServerEnvironmentImpl
implements ServerEnvironment {
    public static final String kGeneratedDirName = "generated";
    public static final String kRepositoryDirName = "applications";
    public static final String kAppAltDDDirName = "altdd";
    public static final String kEJBStubDirName = "ejb";
    public static final String kGeneratedXMLDirName = "xml";
    public static final String kPolicyFileDirName = "policy";
    public static final String kConfigXMLFileName = "domain.xml";
    public static final String kConfigXMLFileNameBackup = "domain.xml.bak";
    public static final String kLoggingPropertiesFileName = "logging.properties";
    public static final String kDefaultLoggingPropertiesFileName = "default-logging.properties";
    public static final String kConfigDirName = "config";
    public static final String kInitFileName = "init.conf";
    public static final String DEFAULT_ADMIN_CONSOLE_CONTEXT_ROOT = "/admin";
    public static final String DEFAULT_ADMIN_CONSOLE_APP_NAME = "__admingui";
    @Inject
    StartupContext startupContext;
    private File root;
    private boolean verbose;
    private boolean debug;
    private ASenvPropertyReader asenv;
    private String domainName;
    private String instanceName;
    private RuntimeType serverType = RuntimeType.DAS;
    private ServerEnvironment.Status status = ServerEnvironment.Status.starting;

    public ServerEnvironmentImpl() {
    }

    public ServerEnvironmentImpl(File root) {
        this.root = root.getAbsoluteFile();
        this.asenv = new ASenvPropertyReader();
    }

    /*
     * WARNING - void declaration
     */
    @PostConstruct
    public void postConstruct() {
        void var3_10;
        String installRoot = this.startupContext.getArguments().getProperty(GlassFishVariable.INSTALL_ROOT.getPropertyName());
        if (installRoot == null) {
            installRoot = System.getProperty(GlassFishVariable.INSTALL_ROOT.getSystemPropertyName()) == null ? System.getProperty("user.dir") : System.getProperty(GlassFishVariable.INSTALL_ROOT.getSystemPropertyName());
        }
        this.asenv = new ASenvPropertyReader(new File(installRoot));
        if (this.root == null) {
            String envVar = System.getProperty(GlassFishVariable.INSTANCE_ROOT.getSystemPropertyName());
            if (envVar != null) {
                this.root = new File(envVar);
            } else {
                void var3_5;
                String string = this.startupContext.getArguments().getProperty(GlassFishVariable.INSTANCE_ROOT.getPropertyName());
                if (string == null) {
                    String string2 = installRoot;
                }
                this.root = new File((String)var3_5);
            }
        }
        this.asenv.getProps().put(GlassFishVariable.INSTANCE_ROOT.getPropertyName(), this.root.getAbsolutePath());
        for (Map.Entry entry : this.asenv.getProps().entrySet()) {
            if (entry.getValue() == null) continue;
            SystemProperties.setProperty((String)entry.getKey(), (String)entry.getValue(), true);
        }
        Properties args = this.startupContext.getArguments();
        this.verbose = Boolean.parseBoolean(args.getProperty("-verbose"));
        this.debug = Boolean.parseBoolean(args.getProperty("-debug"));
        String string = args.getProperty("-domainname");
        if (!this.isNotEmpty(string)) {
            String string3 = this.root.getName();
        }
        this.domainName = var3_10;
        String string4 = args.getProperty("-instancename");
        this.instanceName = this.isNotEmpty(string4) ? string4 : "server";
        this.asenv.getProps().put("com.sun.aas.instanceName", this.instanceName);
        SystemProperties.setProperty("com.sun.aas.instanceName", this.instanceName, true);
        String typeString = args.getProperty("-type");
        try {
            if (typeString != null) {
                this.serverType = RuntimeType.valueOf(typeString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDomainName() {
        return this.domainName;
    }

    @Override
    public File getInstanceRoot() {
        return this.root;
    }

    @Override
    public StartupContext getStartupContext() {
        return this.startupContext;
    }

    @Override
    public File getConfigDirPath() {
        return new File(this.root, kConfigDirName);
    }

    @Override
    public File getApplicationRepositoryPath() {
        return new File(this.root, kRepositoryDirName);
    }

    @Override
    public File getApplicationStubPath() {
        return new File(this.root, kGeneratedDirName);
    }

    public File getInitFilePath() {
        return new File(this.getConfigDirPath(), kInitFileName);
    }

    @Override
    public File getLibPath() {
        return new File(this.root, "lib");
    }

    @Override
    public File getApplicationEJBStubPath() {
        return new File(this.getApplicationStubPath(), kEJBStubDirName);
    }

    @Override
    public File getApplicationGeneratedXMLPath() {
        return new File(this.getApplicationStubPath(), kGeneratedXMLDirName);
    }

    @Override
    public File getApplicationCompileJspPath() {
        return new File(this.getApplicationStubPath(), "jsp");
    }

    @Override
    public File getApplicationPolicyFilePath() {
        return new File(this.getApplicationStubPath(), kPolicyFileDirName);
    }

    @Override
    public File getApplicationAltDDPath() {
        return new File(this.getApplicationStubPath(), kAppAltDDDirName);
    }

    public final String getProp(String key) {
        return this.getProps().get(key);
    }

    public Map<String, String> getProps() {
        return Collections.unmodifiableMap(this.asenv.getProps());
    }

    public File getDefaultAdminConsoleFolderOnDisk() {
        File install = new File(this.asenv.getProps().get(GlassFishVariable.INSTALL_ROOT.getPropertyName()));
        return new File(new File(new File(install, "lib"), "install"), kRepositoryDirName);
    }

    @Override
    public File getMasterPasswordFile() {
        return new File(this.getInstanceRoot(), "master-password.p12");
    }

    @Override
    public File getJKS() {
        return new File(this.getConfigDirPath(), "keystore.p12");
    }

    @Override
    public File getTrustStore() {
        return new File(this.getConfigDirPath(), "cacerts.p12");
    }

    @Override
    public ServerEnvironment.Status getStatus() {
        return this.status;
    }

    public void setStatus(ServerEnvironment.Status status) {
        this.status = status;
    }

    @Override
    public boolean isEmbedded() {
        return this.serverType == RuntimeType.EMBEDDED;
    }

    @Override
    public RuntimeType getRuntimeType() {
        return this.serverType;
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public boolean isInstance() {
        return this.serverType == RuntimeType.INSTANCE;
    }

    @Override
    public boolean isDas() {
        return this.serverType == RuntimeType.DAS || this.isEmbedded();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    private boolean isNotEmpty(String s) {
        return s != null && !s.isEmpty();
    }
}

