/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.runnablejar.commandline;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.runnablejar.UberMain;
import org.glassfish.runnablejar.commandline.Option;
import org.glassfish.runnablejar.commandline.UnknownPropertyException;
import org.glassfish.runnablejar.commandline.WordWrapCollector;

public class Arguments {
    private static final Logger logger = Logger.getLogger(Arguments.class.getName());
    public static final String DEFAULT_HTTP_LISTENER = "http-listener";
    public static final String DEFAULT_HTTPS_LISTENER = "https-listener";
    public static final String DEFAULT_PROPERTIES_FILE = "glassfish.properties";
    public static final String DEFAULT_AUTO_DEPLOY_DIR = "autodeploy";
    public static final String DEFAULT_DOMAIN_DIRECTORY = "glassfish-domain";
    public static final String DEFAULT_DOMAIN_CONFIG_FILE = "domain.xml";
    public static final String COMMAND_KEY_PREFIX = "command.";
    public static final String DEPLOY_KEY_PREFIX = "deploy.";
    private static final int HELP_LINE_LENGTH = 80;
    private static final String HELP_FIRST_LINE_INDENT = "    ";
    private static final String HELP_LINE_INDENT = "        ";
    public final List<String> commands = new ArrayList<String>();
    public final GlassFishProperties glassFishProperties = new GlassFishProperties();
    public final List<String> deployables = new ArrayList<String>();
    public boolean askedForHelp = false;
    public boolean noInfo = false;
    public boolean shutdown = false;
    public boolean prompt = false;
    private String argumentsDocList = null;

    public void setDefaults() {
        this.glassFishProperties.setPort(DEFAULT_HTTP_LISTENER, 8080);
        if (new File(DEFAULT_PROPERTIES_FILE).isFile()) {
            try {
                this.setOption(Option.PROPERTIES, DEFAULT_PROPERTIES_FILE);
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, e, () -> "Could not read properties from the implicit properties file glassfish.properties - " + e.getMessage());
            }
        }
        if (new File(DEFAULT_AUTO_DEPLOY_DIR).isDirectory()) {
            try {
                this.setOption(Option.AUTO_DEPLOY_DIR, DEFAULT_AUTO_DEPLOY_DIR);
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, e, () -> "Could not find applications in the implicit directory autodeploy - " + e.getMessage());
            }
        }
        if (new File(DEFAULT_DOMAIN_DIRECTORY).isDirectory()) {
            try {
                this.setOption(Option.DOMAIN_DIR, DEFAULT_DOMAIN_DIRECTORY);
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, e, () -> "Corrupted implicit domain directory glassfish-domain - " + e.getMessage());
            }
        }
        if (new File(DEFAULT_DOMAIN_CONFIG_FILE).isFile()) {
            try {
                this.setOption(Option.DOMAIN_CFG_FILE, DEFAULT_DOMAIN_CONFIG_FILE);
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, e, () -> "Corrupted implicit domain configuration file domain.xml - " + e.getMessage());
            }
        }
    }

    public void setOption(Option option, String value) {
        option.handle(value, this);
    }

    public void addCommand(String command) {
        this.commands.add(command);
    }

    public void addDeployable(String deployable) {
        this.deployables.add(deployable);
    }

    Option setOption(String key, String value) throws UnknownPropertyException {
        try {
            Option option;
            try {
                option = Option.from(key);
            }
            catch (NoSuchElementException e) {
                if (value != null) {
                    if (key.startsWith(COMMAND_KEY_PREFIX)) {
                        this.commands.add(value);
                    } else if (key.startsWith(DEPLOY_KEY_PREFIX)) {
                        this.deployables.add(value);
                    } else {
                        this.glassFishProperties.setProperty(key, value);
                    }
                } else {
                    throw new UnknownPropertyException(key, value);
                }
                return null;
            }
            option.handle(value, this);
            return option;
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, e, () -> "Could not set property " + key + " to value " + value + " - " + e.getMessage());
            return null;
        }
    }

    public void printHelp() {
        this.printHelp(System.out::println);
    }

    public String getHelpText() {
        StringBuilder sb = new StringBuilder();
        this.printHelp(sb::append);
        return sb.toString();
    }

    public void printHelp(Consumer<String> lineConsumer) {
        try (BufferedReader manPageReader = this.openManPageReader();){
            manPageReader.lines().map(this::replaceArguments).map(this::replaceOptions).forEach(lineConsumer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String replaceArguments(String line) {
        return line.replace("${ARGUMENTS}", this.getArgumentsDocList());
    }

    private String getArgumentsDocList() {
        if (this.argumentsDocList == null) {
            WordWrapCollector wordWrapper = new WordWrapCollector(80, 40, HELP_LINE_INDENT);
            this.argumentsDocList = Stream.concat(Arrays.stream(Option.values()).map(option -> "[" + option.getUsage() + "]"), Stream.of("[applications or admin commands...]")).collect(wordWrapper);
        }
        return this.argumentsDocList;
    }

    private String replaceOptions(String line) {
        String options = Arrays.stream(Option.values()).map(option -> {
            WordWrapCollector wordWrapper = new WordWrapCollector(80, HELP_LINE_INDENT.length(), HELP_LINE_INDENT);
            return HELP_FIRST_LINE_INDENT + option.getUsage() + "\n        " + this.getStreamOfWords(option.getHelpText()).collect(wordWrapper);
        }).collect(Collectors.joining("\n\n"));
        return line.replace("${OPTIONS}", options);
    }

    protected Stream<String> getStreamOfWords(String helpText) {
        return Arrays.stream(helpText.split(" "));
    }

    private BufferedReader openManPageReader() {
        InputStream manPageInputStream = this.getClass().getClassLoader().getResourceAsStream(UberMain.class.getPackageName().replace(".", "/") + "/glassfish-embedded.1");
        return new BufferedReader(new InputStreamReader(manPageInputStream, StandardCharsets.UTF_8));
    }
}

