/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.module;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resources.admin.cli.SunResourcesXML;
import org.glassfish.resources.api.Resource;
import org.glassfish.resources.api.ResourceAttributes;

public class ResourceUtilities {
    private static final Logger _logger = LogDomains.getLogger(ResourceUtilities.class, "jakarta.enterprise.resource.resourceadapter");
    private static final StringManager localStrings = StringManager.getManager(ResourceUtilities.class);

    private ResourceUtilities() {
    }

    private static SimpleJndiName getIdToCompare(Resource res) {
        ResourceAttributes attrs = res.getAttributes();
        String type2 = res.getType();
        String id = "jdbc-connection-pool".equals(type2) || "connector-connection-pool".equals(type2) ? ResourceUtilities.getNamedAttributeValue(attrs, "name") : ("security-map".equals(type2) ? ResourceUtilities.getNamedAttributeValue(attrs, "name") : ("resource-adapter-config".equals(type2) ? ResourceUtilities.getNamedAttributeValue(attrs, "resource-adapter-name") : ("work-security-map".equals(type2) ? ResourceUtilities.getNamedAttributeValue(attrs, "name") : ResourceUtilities.getNamedAttributeValue(attrs, "jndi-name"))));
        return SimpleJndiName.of(id);
    }

    private static String getNamedAttributeValue(ResourceAttributes attrs, String name) {
        return attrs.getString(name);
    }

    public static Set<Resource> resolveResourceDuplicatesConflictsWithinArchive(List<SunResourcesXML> sunResList) throws ResourceConflictException {
        StringBuilder conflictingResources = new StringBuilder();
        HashSet<Resource> resourceSet = new HashSet<Resource>();
        for (SunResourcesXML sunResXML : sunResList) {
            List<Resource> resources = sunResXML.getResourcesList();
            for (Resource res : resources) {
                boolean addResource = true;
                for (Resource existingRes : resourceSet) {
                    if (existingRes.equals(res)) {
                        addResource = false;
                        _logger.warning(localStrings.getString("duplicate.resource.sun.resource.xml", ResourceUtilities.getIdToCompare(res), sunResXML.getXMLPath()));
                        break;
                    }
                    if (!existingRes.isAConflict(res)) continue;
                    addResource = false;
                    conflictingResources.append("\n");
                    String message = localStrings.getString("conflict.resource.sun.resource.xml", ResourceUtilities.getIdToCompare(res), sunResXML.getXMLPath());
                    conflictingResources.append(message);
                    _logger.warning(message);
                    _logger.fine(localStrings.getString("resource.attributes", res.getAttributes()));
                }
                if (!addResource) continue;
                resourceSet.add(res);
            }
        }
        if (conflictingResources.toString().length() > 0) {
            throw new ResourceConflictException(conflictingResources.toString());
        }
        return resourceSet;
    }
}

