/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.mail.naming;

import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.logging.LogDomains;
import jakarta.mail.Session;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.glassfish.resources.mail.MailLogOutputStream;
import org.glassfish.resources.mail.MailSessionAuthenticator;

public class MailNamingObjectFactory
implements ObjectFactory {
    private static final Logger LOG = LogDomains.getLogger(MailNamingObjectFactory.class, "jakarta.enterprise.system.core.naming", false);

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "MailNamingObjectFactory: " + String.valueOf(ref) + " Name:" + String.valueOf(name));
        }
        MailConfiguration config = (MailConfiguration)ref.get(0).getContent();
        Properties props = config.getMailProperties();
        Session s = Session.getInstance(props, new MailSessionAuthenticator(props));
        if ("smtps".equals(props.getProperty("mail.transport.protocol"))) {
            s.setProtocolForAddress("rfc822", "smtps");
        }
        s.setDebugOut(new PrintStream(new MailLogOutputStream()));
        s.setDebug(true);
        return s;
    }
}

