/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.glassfish.resources.api.ResourceAttributes;

public class Resource {
    public static final String CUSTOM_RESOURCE = "custom-resource";
    public static final String CONNECTOR_RESOURCE = "connector-resource";
    public static final String ADMIN_OBJECT_RESOURCE = "admin-object-resource";
    public static final String JDBC_RESOURCE = "jdbc-resource";
    public static final String MAIL_RESOURCE = "mail-resource";
    public static final String EXTERNAL_JNDI_RESOURCE = "external-jndi-resource";
    public static final String JDBC_CONNECTION_POOL = "jdbc-connection-pool";
    public static final String CONNECTOR_CONNECTION_POOL = "connector-connection-pool";
    public static final String RESOURCE_ADAPTER_CONFIG = "resource-adapter-config";
    public static final String PERSISTENCE_MANAGER_FACTORY_RESOURCE = "persistence-manager-factory-resource";
    public static final String CONNECTOR_SECURITY_MAP = "security-map";
    public static final String CONNECTOR_WORK_SECURITY_MAP = "work-security-map";
    public static final List BINDABLE_RESOURCES = Collections.unmodifiableList(Arrays.asList("custom-resource", "connector-resource", "admin-object-resource", "jdbc-resource", "mail-resource", "external-jndi-resource"));
    public static final List RESOURCE_POOL = Collections.unmodifiableList(Arrays.asList("jdbc-connection-pool", "connector-connection-pool"));
    private final String resType;
    private final ResourceAttributes attributes = new ResourceAttributes();
    private final Properties props = new Properties();
    private String sDescription = null;

    public Resource(String type2) {
        this.resType = type2;
    }

    public String getType() {
        return this.resType;
    }

    public ResourceAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttribute(String name, String value) {
        this.attributes.set(name, value);
    }

    public void setAttribute(String name, String[] value) {
        this.attributes.set(name, value);
    }

    public void setAttribute(String name, Properties value) {
        this.attributes.set(name, value);
    }

    public void setDescription(String sDescription) {
        this.sDescription = sDescription;
    }

    public String getDescription() {
        return this.sDescription;
    }

    public void setProperty(String name, String value) {
        this.props.setProperty(name, value);
    }

    public Properties getProperties() {
        return this.props;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource otherr = (Resource)obj;
        return otherr.getType().equals(this.getType()) && otherr.getProperties().equals(this.getProperties()) && otherr.getAttributes().equals(this.getAttributes());
    }

    public int hashCode() {
        return Objects.hash(this.getAttributes(), this.getProperties(), this.getType());
    }

    public boolean isAConflict(Resource r) {
        return this.hasSameIdentity(r) && !r.equals(this);
    }

    private boolean hasSameIdentity(Resource r) {
        if (BINDABLE_RESOURCES.contains(this.getType()) ? !BINDABLE_RESOURCES.contains(r.getType()) : (RESOURCE_POOL.contains(this.getType()) ? !RESOURCE_POOL.contains(r.getType()) : !r.getType().equals(this.getType()))) {
            return false;
        }
        String rType = r.getType();
        if (rType.equals(CUSTOM_RESOURCE) || rType.equals(EXTERNAL_JNDI_RESOURCE) || rType.equals(JDBC_RESOURCE) || rType.equals(PERSISTENCE_MANAGER_FACTORY_RESOURCE) || rType.equals(CONNECTOR_RESOURCE) || rType.equals(ADMIN_OBJECT_RESOURCE) || rType.equals(MAIL_RESOURCE)) {
            return this.isEqualAttribute(r, "jndi-name");
        }
        if (rType.equals(JDBC_CONNECTION_POOL) || rType.equals(CONNECTOR_CONNECTION_POOL)) {
            return this.isEqualAttribute(r, "name");
        }
        if (rType.equals(RESOURCE_ADAPTER_CONFIG)) {
            return this.isEqualAttribute(r, "resource-adapter-name");
        }
        if (rType.equals(CONNECTOR_WORK_SECURITY_MAP)) {
            return this.isEqualAttribute(r, "name") && this.isEqualAttribute(r, "resource-adapter-name");
        }
        return false;
    }

    private boolean isEqualAttribute(Resource r, String name) {
        return this.getAttribute(r, name).equals(this.getAttribute(this, name));
    }

    private String getAttribute(Resource r, String name) {
        return r.getAttributes().getString(name);
    }

    public String toString() {
        String rType = this.getType();
        String identity = rType.equals(CUSTOM_RESOURCE) || rType.equals(EXTERNAL_JNDI_RESOURCE) || rType.equals(JDBC_RESOURCE) || rType.equals(PERSISTENCE_MANAGER_FACTORY_RESOURCE) || rType.equals(CONNECTOR_RESOURCE) || rType.equals(ADMIN_OBJECT_RESOURCE) || rType.equals(MAIL_RESOURCE) ? this.getAttribute(this, "jndi-name") : (rType.equals(JDBC_CONNECTION_POOL) || rType.equals(CONNECTOR_CONNECTION_POOL) ? this.getAttribute(this, "name") : (rType.equals(RESOURCE_ADAPTER_CONFIG) ? this.getAttribute(this, "resource-adapter-name") : (rType.equals(CONNECTOR_WORK_SECURITY_MAP) ? this.getAttribute(this, "name") : "")));
        return identity + " of type " + this.resType;
    }
}

