/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.admin.cli;

import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.resource.ResourceException;
import java.beans.PropertyVetoException;
import java.util.Properties;
import org.glassfish.api.I18n;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.admin.cli.ResourceUtil;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.glassfish.resources.admin.cli.ResourceManager;
import org.glassfish.resources.api.ResourceAttributes;
import org.glassfish.resources.config.CustomResource;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="custom-resource")
@PerLookup
@I18n(value="create.custom.resource")
public class CustomResourceManager
implements ResourceManager {
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(CustomResourceManager.class);
    @Inject
    private ResourceUtil resourceUtil;
    @Inject
    private BindableResourcesHelper resourcesHelper;
    private String resType;
    private String factoryClass;
    private String enabled;
    private String enabledValueForTarget;
    private String description;
    private String jndiName;

    @Override
    public String getResourceType() {
        return "custom-resource";
    }

    @Override
    public ResourceStatus create(Resources resources, ResourceAttributes attributes, Properties properties, String target) throws Exception {
        this.setAttributes(attributes, target);
        ResourceStatus validationStatus = this.isValid(resources, true, target);
        if (validationStatus.getStatus() == 1) {
            return validationStatus;
        }
        try {
            SingleConfigCode<Resources> configCode = param -> this.createResource((Resources)param, properties);
            ConfigSupport.apply(configCode, resources);
            if (!"domain".equals(target)) {
                this.resourceUtil.createResourceRef(this.jndiName, this.enabledValueForTarget, target);
            }
        }
        catch (TransactionFailure tfe) {
            String msg = I18N.getLocalString("create.custom.resource.fail", "Unable to create custom resource {0}.", this.jndiName) + " " + tfe.getLocalizedMessage();
            return new ResourceStatus(1, msg, true);
        }
        String msg = I18N.getLocalString("create.custom.resource.success", "Custom Resource {0} created.", this.jndiName);
        return new ResourceStatus(0, msg, true);
    }

    private ResourceStatus isValid(Resources resources, boolean validateResourceRef, String target) {
        if (this.resType == null) {
            String msg = I18N.getLocalString("create.custom.resource.noResType", "No type defined for Custom Resource.");
            return new ResourceStatus(1, msg, true);
        }
        if (this.factoryClass == null) {
            String msg = I18N.getLocalString("create.custom.resource.noFactoryClassName", "No Factory class name defined for Custom Resource.");
            return new ResourceStatus(1, msg, true);
        }
        ResourceStatus status = this.resourcesHelper.validateBindableResourceForDuplicates(resources, this.jndiName, validateResourceRef, target, CustomResource.class);
        if (status.getStatus() == 1) {
            return status;
        }
        return status;
    }

    private void setAttributes(ResourceAttributes attributes, String target) {
        this.jndiName = attributes.getString("jndi-name");
        this.resType = attributes.getString("res-type");
        this.factoryClass = attributes.getString("factory-class");
        this.enabled = target == null ? attributes.getString("enabled") : this.resourceUtil.computeEnabledValueForResourceBasedOnTarget(attributes.getString("enabled"), target);
        this.enabledValueForTarget = attributes.getString("enabled");
        this.description = attributes.getString("description");
    }

    private Object createResource(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        CustomResource newResource = this.createConfigBean(param, properties);
        param.getResources().add(newResource);
        return newResource;
    }

    private CustomResource createConfigBean(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        CustomResource newResource = param.createChild(CustomResource.class);
        newResource.setJndiName(this.jndiName);
        newResource.setFactoryClass(this.factoryClass);
        newResource.setResType(this.resType);
        newResource.setEnabled(this.enabled);
        if (this.description != null) {
            newResource.setDescription(this.description);
        }
        if (properties != null) {
            for (String propertyName : properties.stringPropertyNames()) {
                Property prop = newResource.createChild(Property.class);
                prop.setName(propertyName);
                prop.setValue(properties.getProperty(propertyName));
                newResource.getProperty().add(prop);
            }
        }
        return newResource;
    }

    @Override
    public Resource createConfigBean(Resources resources, ResourceAttributes attributes, Properties properties, boolean validate) throws Exception {
        this.setAttributes(attributes, null);
        ResourceStatus status = validate ? this.isValid(resources, false, null) : new ResourceStatus(0, "");
        if (status.getStatus() == 0) {
            return this.createConfigBean(resources, properties);
        }
        throw new ResourceException(status.getMessage(), status.getException());
    }
}

