/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resourcebase.resources.util;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.jvnet.hk2.annotations.Service;

@Service
public class BindableResourcesHelper {
    @LogMessagesResourceBundle
    public static final String LOGMESSAGE_RESOURCE = "org.glassfish.resourcebase.resources.LogMessages";
    @LoggerInfo(subsystem="RESOURCE", description="Nucleus Resource", publish=true)
    public static final String LOGGER = "jakarta.enterprise.resources.util";
    private static final Logger LOG = Logger.getLogger("jakarta.enterprise.resources.util", "org.glassfish.resourcebase.resources.LogMessages");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(BindableResourcesHelper.class);
    private static final String DOMAIN = "domain";
    @Inject
    ServiceLocator habitat;
    @Inject
    private ServerEnvironment environment;
    private Server server;

    public boolean resourceExists(String jndiName, String target) {
        boolean exists = false;
        Domain domain = this.habitat.getService(Domain.class, new Annotation[0]);
        if (target.equals(DOMAIN)) {
            exists = true;
        } else {
            SimpleJndiName simpleJndiName = SimpleJndiName.of(jndiName);
            if (this.habitat.getService(ConfigBeansUtilities.class, new Annotation[0]).getServerNamed(target) != null) {
                Server server = this.habitat.getService(ConfigBeansUtilities.class, new Annotation[0]).getServerNamed(target);
                exists = server.isResourceRefExists(simpleJndiName);
            } else if (domain.getClusterNamed(target) != null) {
                Cluster cluster = domain.getClusterNamed(target);
                exists = cluster.isResourceRefExists(simpleJndiName);
            } else {
                for (Config config : domain.getConfigs().getConfig()) {
                    if (!config.getName().equals(target)) continue;
                    exists = true;
                    break;
                }
            }
        }
        return exists;
    }

    public ResourceStatus validateBindableResourceForDuplicates(Resources resources, String jndiName, boolean validateResourceRef, String target, Class<? extends BindableResource> resourceTypeToValidate) {
        SimpleJndiName simpleJndiName = SimpleJndiName.of(jndiName);
        Object duplicateResource = ResourceUtil.getBindableResourceByName(resources, jndiName);
        if (duplicateResource == null) {
            return new ResourceStatus(0, "Validation Successful");
        }
        String msg = validateResourceRef && this.getResourceByClass((BindableResource)duplicateResource).equals(resourceTypeToValidate) ? (DOMAIN.equals(target) ? localStrings.getLocalString("duplicate.resource.found", "A {0} by name {1} already exists.", this.getResourceTypeName((BindableResource)duplicateResource), jndiName) : (this.habitat.getService(org.glassfish.resourcebase.resources.admin.cli.ResourceUtil.class, new Annotation[0]).getTargetsReferringResourceRef(simpleJndiName).contains(target) ? localStrings.getLocalString("duplicate.resource.found.in.target", "A {0} by name {1} already exists with resource-ref in target {2}.", this.getResourceTypeName((BindableResource)duplicateResource), jndiName, target) : localStrings.getLocalString("duplicate.resource.need.to.create.resource.ref", "A {0} named {1} already exists. If you are trying to create the existing resourceconfiguration in target {2}, please use 'create-resource-ref' command (or create resource-ref using admin console).", this.getResourceTypeName((BindableResource)duplicateResource), jndiName, target))) : localStrings.getLocalString("duplicate.resource.found", "A {0} by name {1} already exists.", this.getResourceTypeName((BindableResource)duplicateResource), jndiName);
        return new ResourceStatus(1, msg, true);
    }

    public Class<? extends BindableResource> getResourceByClass(BindableResource resource) {
        Class<?>[] interfaces;
        Class<BindableResource> type2 = BindableResource.class;
        if (Proxy.isProxyClass(resource.getClass()) && (interfaces = resource.getClass().getInterfaces()) != null) {
            for (Class<?> clz : interfaces) {
                if (!BindableResource.class.isAssignableFrom(clz)) continue;
                return clz;
            }
        }
        return type2;
    }

    public String getResourceTypeName(BindableResource resource) {
        Class<? extends BindableResource> resourceType = this.getResourceByClass(resource);
        return resourceType == null ? "Resource" : resourceType.getSimpleName();
    }

    public boolean isBindableResourceEnabled(BindableResource br) {
        boolean resourceRefEnabled = false;
        ResourceRef ref = this.getServer().getResourceRef(SimpleJndiName.of(br.getJndiName()));
        if (ref == null) {
            LOG.log(Level.FINEST, "ResourceRef {0} was not found.", br.getJndiName());
        } else {
            resourceRefEnabled = Boolean.parseBoolean(ref.getEnabled());
        }
        boolean resourceEnabled = Boolean.parseBoolean(br.getEnabled());
        return resourceEnabled && resourceRefEnabled;
    }

    private Server getServer() {
        if (this.server == null) {
            this.server = this.habitat.getService(Domain.class, new Annotation[0]).getServerNamed(this.environment.getInstanceName());
        }
        return this.server;
    }
}

