/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resourcebase.resources.admin.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class ResourceUtil {
    private static final System.Logger LOG = System.getLogger(ResourceUtil.class.getName());
    @Inject
    private Provider<Target> targetProvider;
    @Inject
    private Domain domain;
    @Inject
    private ConfigBeansUtilities configBeansUtilities;

    public void createResourceRef(String name, String enabled, String target) throws TransactionFailure {
        Server server;
        LOG.log(System.Logger.Level.DEBUG, "createResourceRef(name={0}, enabled={1}, target={2})", name, enabled, target);
        if ("domain".equals(target)) {
            throw new IllegalArgumentException("Target " + target + " is not allowed for creating resource refs!");
        }
        SimpleJndiName jndiName = SimpleJndiName.of(name);
        Config config = this.domain.getConfigNamed(target);
        if (config != null && !config.isResourceRefExists(jndiName)) {
            config.createResourceRef(enabled, jndiName);
        }
        if ((server = this.configBeansUtilities.getServerNamed(target)) != null) {
            if (!server.isResourceRefExists(jndiName)) {
                server.createResourceRef(enabled, jndiName);
            }
        } else {
            Cluster cluster = this.domain.getClusterNamed(target);
            if (cluster != null && !cluster.isResourceRefExists(jndiName)) {
                cluster.createResourceRef(enabled, jndiName);
                Target tgt = this.targetProvider.get();
                List<Server> instances = tgt.getInstances(target);
                for (Server svr : instances) {
                    if (svr.isResourceRefExists(jndiName)) continue;
                    svr.createResourceRef(enabled, jndiName);
                }
            }
        }
    }

    public String computeEnabledValueForResourceBasedOnTarget(String enabledValue, String target) {
        boolean enabled = Boolean.parseBoolean(enabledValue);
        if (!this.isNonResourceRefTarget(target) && !enabled) {
            return Boolean.toString(!enabled);
        }
        return enabledValue;
    }

    private boolean isNonResourceRefTarget(String target) {
        if ("domain".equals(target)) {
            return true;
        }
        return this.domain.getConfigNamed(target) != null;
    }

    public boolean isResourceRefInTarget(SimpleJndiName refName, String target) {
        Set<String> targets = this.getTargetsReferringResourceRef(refName);
        for (String refTarget : targets) {
            if (!refTarget.equals(target)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getTargetsReferringResourceRef(SimpleJndiName refName) {
        HashSet<String> targets = new HashSet<String>();
        List<Server> servers = this.domain.getServers().getServer();
        for (Server server : servers) {
            if (server.getResourceRef(refName) == null) continue;
            if (server.getCluster() != null) {
                targets.add(server.getCluster().getName());
                continue;
            }
            if (server.isDas()) {
                targets.add("server");
                continue;
            }
            if (!server.isInstance()) continue;
            targets.add(server.getName());
        }
        return targets;
    }

    public void deleteResourceRef(SimpleJndiName jndiName, String target) throws TransactionFailure {
        LOG.log(System.Logger.Level.DEBUG, "deleteResourceRef(jndiName={0}, target={1})", jndiName, target);
        if ("domain".equals(target)) {
            throw new IllegalArgumentException("Target " + target + " is not allowed for deleting resource refs!");
        }
        Config config = this.domain.getConfigNamed(target);
        if (config != null) {
            config.deleteResourceRef(jndiName);
        } else {
            Server server = this.configBeansUtilities.getServerNamed(target);
            if (server != null) {
                if (server.isResourceRefExists(jndiName)) {
                    server.deleteResourceRef(jndiName);
                }
            } else {
                Cluster cluster = this.domain.getClusterNamed(target);
                if (cluster != null && cluster.isResourceRefExists(jndiName)) {
                    cluster.deleteResourceRef(jndiName);
                    Target tgt = this.targetProvider.get();
                    List<Server> instances = tgt.getInstances(target);
                    for (Server svr : instances) {
                        if (!svr.isResourceRefExists(jndiName)) continue;
                        svr.deleteResourceRef(jndiName);
                    }
                }
            }
        }
    }
}

