/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.orb.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.orb.admin.config.IiopListener;
import org.glassfish.orb.admin.config.IiopService;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-iiop-listeners")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.iiop.listeners")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.DOMAIN})
@RestEndpoints(value={@RestEndpoint(configBean=IiopService.class, opType=RestEndpoint.OpType.GET, path="list-iiop-listeners", description="list-iiop-listeners")})
public class ListIiopListeners
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListIiopListeners.class);
    @Param(primary=true, name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    ServiceLocator services;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Target targetUtil = this.services.getService(Target.class, new Annotation[0]);
        Config config = targetUtil.getConfig(this.target);
        IiopService iiopService = config.getExtensionByType(IiopService.class);
        try {
            List listenerList = iiopService.getIiopListener();
            for (IiopListener listener : listenerList) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(listener.getId());
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.iiop.listener.fail", "List IIOP listeners failed."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }
}

