/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.microprofile.health.service;

import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.glassfish.internal.api.Globals;
import org.glassfish.microprofile.health.HealthReport;
import org.glassfish.microprofile.health.HealthReporter;

public class HealthServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(HealthServlet.class.getName());

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HealthReport healthReport;
        try {
            healthReport = Globals.getDefaultHabitat().getService(HealthReporter.class, new Annotation[0]).getReport(HealthServlet.getReportKind(req.getRequestURI()));
            int httpStatus = switch (healthReport.status()) {
                default -> throw new MatchException(null, null);
                case HealthCheckResponse.Status.UP -> 200;
                case HealthCheckResponse.Status.DOWN -> 503;
            };
            resp.setStatus(httpStatus);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to fetch health check status", e);
            healthReport = new HealthReport(HealthCheckResponse.Status.DOWN, List.of());
            resp.setStatus(500);
        }
        Jsonb jsonb = JsonbBuilder.create();
        String json = jsonb.toJson(healthReport);
        resp.setCharacterEncoding("UTF-8");
        resp.setContentType("application/json");
        resp.getWriter().println(json);
    }

    private static HealthReporter.ReportKind getReportKind(String path) {
        if (path.endsWith("health/live")) {
            return HealthReporter.ReportKind.LIVE;
        }
        if (path.endsWith("health/ready")) {
            return HealthReporter.ReportKind.READY;
        }
        if (path.endsWith("health/started")) {
            return HealthReporter.ReportKind.STARTED;
        }
        return HealthReporter.ReportKind.ALL;
    }
}

