/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.microprofile.health.service;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.eclipse.microprofile.health.Startup;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.internal.api.Globals;
import org.glassfish.microprofile.health.HealthCheckInfo;
import org.glassfish.microprofile.health.HealthReporter;

public class CollectHealthChecksExtension
implements Extension {
    private final HealthReporter service;
    private final Set<HealthCheckBeanAndKind> healthChecks = Collections.newSetFromMap(new ConcurrentHashMap());
    private final InvocationManager invocationManager;

    public CollectHealthChecksExtension() {
        ServiceLocator defaultBaseServiceLocator = Globals.getDefaultBaseServiceLocator();
        this.invocationManager = Globals.get(InvocationManager.class);
        HealthReporter healthReporterService = defaultBaseServiceLocator.getService(HealthReporter.class, new Annotation[0]);
        if (healthReporterService == null) {
            ServiceLocatorUtilities.addClasses(defaultBaseServiceLocator, true, HealthReporter.class);
            healthReporterService = defaultBaseServiceLocator.getService(HealthReporter.class, new Annotation[0]);
        }
        this.service = healthReporterService;
    }

    public <T> void processBeans(@Observes ProcessBean<T> beans) {
        Bean<HealthCheck> bean;
        Annotated annotated = beans.getAnnotated();
        boolean livenessPresent = annotated.isAnnotationPresent(Liveness.class);
        boolean readinessPresent = annotated.isAnnotationPresent(Readiness.class);
        boolean startupPresent = annotated.isAnnotationPresent(Startup.class);
        if ((livenessPresent || readinessPresent || startupPresent) && (bean = beans.getBean()).getTypes().contains(HealthCheck.class)) {
            EnumSet<HealthCheckInfo.Kind> kinds = EnumSet.noneOf(HealthCheckInfo.Kind.class);
            if (livenessPresent) {
                kinds.add(HealthCheckInfo.Kind.LIVE);
            }
            if (readinessPresent) {
                kinds.add(HealthCheckInfo.Kind.READY);
            }
            if (startupPresent) {
                kinds.add(HealthCheckInfo.Kind.STARTUP);
            }
            this.healthChecks.add(new HealthCheckBeanAndKind(bean, kinds));
        }
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation adv, BeanManager beanManager) {
        this.healthChecks.forEach(healthCheckBeanAndKind -> {
            CreationalContext<HealthCheck> creationalContext;
            Bean<HealthCheck> bean = healthCheckBeanAndKind.bean();
            Object patt0$temp = beanManager.getReference(bean, (Type)((Object)HealthCheck.class), creationalContext = beanManager.createCreationalContext(bean));
            if (patt0$temp instanceof HealthCheck) {
                HealthCheck healthCheck = (HealthCheck)patt0$temp;
                this.service.addHealthCheck(((ComponentInvocation)this.invocationManager.getCurrentInvocation()).getAppName(), new HealthCheckInfo(healthCheck, healthCheckBeanAndKind.kind()));
            }
        });
    }

    record HealthCheckBeanAndKind(Bean<HealthCheck> bean, Set<HealthCheckInfo.Kind> kind) {
    }
}

