/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.boot.osgi;

import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.main.boot.osgi.OSGiGlassFishImpl;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;

public class OSGiGlassFishRuntime
extends GlassFishRuntime {
    private final GlassFishRuntime glassfishRuntime;
    private volatile Framework framework;

    public OSGiGlassFishRuntime(GlassFishRuntime glassfishRuntime, Framework framework) {
        this.glassfishRuntime = glassfishRuntime;
        this.framework = framework;
    }

    @Override
    public void shutdown() throws GlassFishException {
        if (this.framework == null) {
            return;
        }
        try {
            this.glassfishRuntime.shutdown();
            this.framework.stop();
            this.framework.waitForStop(0L);
        }
        catch (InterruptedException ex) {
            throw new GlassFishException(ex);
        }
        catch (BundleException ex) {
            throw new GlassFishException(ex);
        }
        finally {
            this.framework = null;
        }
    }

    @Override
    public GlassFish newGlassFish(GlassFishProperties glassfishProperties) throws GlassFishException {
        GlassFish glassfish = this.glassfishRuntime.newGlassFish(glassfishProperties);
        int finalStartLevel = Integer.parseInt(glassfishProperties.getProperties().getProperty("glassfish.osgi.start.level.final", "2"));
        return new OSGiGlassFishImpl(glassfish, this.framework.getBundleContext(), finalStartLevel);
    }
}

