/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.boot.osgi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.util.tracker.ServiceTracker;

public class OSGiFrameworkLauncher {
    private final Properties properties;
    private final ClassLoader classloader;
    private Framework framework;

    public OSGiFrameworkLauncher(Properties properties, ClassLoader classloader) {
        this.properties = properties;
        this.classloader = classloader;
    }

    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    public Framework launchOSGiFrameWork() throws Exception {
        if (this.isOSGiEnv()) {
            throw new IllegalStateException("An OSGi framework is already running...");
        }
        ServiceLoader<FrameworkFactory> frameworkFactories = ServiceLoader.load(FrameworkFactory.class, this.classloader);
        HashMap<String, String> mm = new HashMap<String, String>();
        for (Map.Entry<Object, Object> e : this.properties.entrySet()) {
            mm.put((String)e.getKey(), (String)e.getValue());
        }
        Iterator<Map.Entry<Object, Object>> iterator = frameworkFactories.iterator();
        if (iterator.hasNext()) {
            FrameworkFactory ff = (FrameworkFactory)iterator.next();
            this.framework = ff.newFramework(mm);
        }
        if (this.framework == null) {
            throw new RuntimeException("No OSGi framework in classpath");
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    OSGiFrameworkLauncher.this.framework.init();
                }
                catch (BundleException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        t.setDaemon(true);
        t.start();
        t.join();
        return this.framework;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getService(Class<T> type2) throws Exception {
        if (this.framework == null) {
            throw new IllegalStateException("OSGi framework has not yet been launched.");
        }
        BundleContext context = this.framework.getBundleContext();
        try (ServiceTracker tracker = new ServiceTracker(context, type2.getName(), null);){
            tracker.open(true);
            Object object = tracker.waitForService(0L);
            return (T)object;
        }
    }

    private boolean isOSGiEnv() {
        return this.classloader instanceof BundleReference;
    }
}

