/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.event;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.kernel.KernelLoggerInfo;

public class EventsImpl
implements Events,
PostConstruct {
    private static final Logger LOG = KernelLoggerInfo.getLogger();
    private final AtomicLong sequenceGenerator = new AtomicLong(0L);
    final Map<Listener, EventMatcher> listenersBySequence = new ConcurrentSkipListMap<Listener, EventMatcher>();
    final Map<EventListener, Listener> listenersByIdentity = new ConcurrentHashMap<EventListener, Listener>();
    private ExecutorService executor;

    @Override
    public void postConstruct() {
        ThreadFactory threadFactory = r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            t.setName("events-" + t.getId());
            return t;
        };
        this.executor = Executors.newCachedThreadPool(threadFactory);
    }

    @Override
    public void register(EventListener listener) {
        try {
            RestrictTo[] restrictTo = (RestrictTo[])listener.getClass().getMethod("event", EventListener.Event.class).getParameters()[0].getAnnotationsByType(RestrictTo.class);
            this.listenersByIdentity.computeIfAbsent(listener, e -> {
                Listener listenerWrapperWithSeq = new Listener(listener, this.sequenceGenerator.getAndIncrement());
                EventMatcher eventMatcher = new EventMatcher((EventTypes[])Arrays.stream(restrictTo).map(restrict -> EventTypes.create(restrict.value())).toArray(EventTypes[]::new));
                this.listenersBySequence.put(listenerWrapperWithSeq, eventMatcher);
                return listenerWrapperWithSeq;
            });
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "NCLS-CORE-00068", t);
        }
    }

    @Override
    public void send(EventListener.Event<?> event) {
        this.send(event, true);
    }

    @Override
    public void send(EventListener.Event<?> event, boolean asynchronously) {
        for (Map.Entry<Listener, EventMatcher> entry : this.listenersBySequence.entrySet()) {
            if (!entry.getValue().matches(event)) continue;
            Listener listener = entry.getKey();
            if (asynchronously) {
                this.executor.submit(() -> {
                    try {
                        listener.event(event);
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, "NCLS-CORE-00069", t);
                    }
                });
                continue;
            }
            try {
                listener.event(event);
            }
            catch (DeploymentException e) {
                throw e;
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "NCLS-CORE-00069", t);
            }
        }
    }

    @Override
    public boolean unregister(EventListener listener) {
        Listener listenerWrapperWithSeq = this.listenersByIdentity.remove(listener);
        if (listenerWrapperWithSeq == null) {
            return false;
        }
        return this.listenersBySequence.remove(listenerWrapperWithSeq) != null;
    }

    static class EventMatcher {
        private final EventTypes<?>[] eventTypes;

        EventMatcher(EventTypes<?>[] eventTypes) {
            this.eventTypes = eventTypes;
        }

        boolean matches(EventListener.Event<?> event) {
            if (this.eventTypes.length == 0) {
                return true;
            }
            return Arrays.stream(this.eventTypes).anyMatch(event::is);
        }
    }

    static class Listener
    implements Comparable<Listener> {
        private final EventListener eventListener;
        private final long sequenceNumber;

        Listener(EventListener eventListener) {
            this(eventListener, -1L);
        }

        Listener(EventListener eventListener, long sequenceNumber) {
            this.eventListener = eventListener;
            this.sequenceNumber = sequenceNumber;
        }

        void event(EventListener.Event<?> event) {
            this.eventListener.event(event);
        }

        EventListener unwrap() {
            return this.eventListener;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof Listener)) return false;
            Listener listener = (Listener)obj;
            if (this.eventListener != listener.eventListener) return false;
            return true;
        }

        public int hashCode() {
            return System.identityHashCode(this.eventListener);
        }

        @Override
        public int compareTo(Listener listener) {
            if (this.eventListener == listener.eventListener) {
                return 0;
            }
            return Long.compare(this.sequenceNumber, listener.sequenceNumber);
        }
    }
}

