/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jts.admin.cli;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Param;

public class RecoverTransactionsBase {
    protected static final StringManager MESSAGES = StringManager.getManager(RecoverTransactionsBase.class);
    protected static final Logger LOG = LogDomains.getLogger(RecoverTransactionsBase.class, "jakarta.enterprise.system.core.transaction", false);
    @Inject
    Servers servers;
    @Param(name="transactionlogdir", optional=true)
    String transactionLogDir;
    @Param(name="server_name", primary=true)
    String serverToRecover;

    String validate(String destinationServer, boolean validateAllParams) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("==> validating target: " + destinationServer + " ... server: " + this.serverToRecover);
        }
        if (this.servers.getServer(this.serverToRecover) == null) {
            return MESSAGES.getString("recover.transactions.serverBeRecoveredIsNotKnown", this.serverToRecover);
        }
        if (this.isServerRunning(this.serverToRecover)) {
            if (destinationServer != null && !this.serverToRecover.equals(destinationServer)) {
                return MESSAGES.getString("recover.transactions.runningServerBeRecoveredFromAnotherServer", this.serverToRecover, destinationServer);
            }
            if (this.transactionLogDir != null) {
                return MESSAGES.getString("recover.transactions.logDirShouldNotBeSpecifiedForSelfRecovery");
            }
        } else {
            if (destinationServer == null) {
                return MESSAGES.getString("recover.transactions.noDestinationServer");
            }
            if (this.servers.getServer(destinationServer) == null) {
                return MESSAGES.getString("recover.transactions.DestinationServerIsNotKnown");
            }
            if (!this.isServerRunning(destinationServer)) {
                return MESSAGES.getString("recover.transactions.destinationServerIsNotAlive", destinationServer);
            }
            if (validateAllParams && this.transactionLogDir == null) {
                return MESSAGES.getString("recover.transactions.logDirNotSpecifiedForDelegatedRecovery");
            }
        }
        return null;
    }

    private boolean isServerRunning(String serverName) {
        for (Server server : this.servers.getServer()) {
            if (!serverName.equals(server.getName())) continue;
            return server.isListeningOnAdminPort();
        }
        return false;
    }
}

