/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.jsp;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import jakarta.servlet.jsp.JspContext;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.SimpleTagSupport;
import java.io.IOException;
import java.io.PrintWriter;
import org.glassfish.jersey.server.mvc.internal.TemplateHelper;
import org.glassfish.jersey.server.mvc.jsp.internal.LocalizationMessages;

public class Include
extends SimpleTagSupport {
    private String page;

    public void setPage(String page) {
        this.page = page;
    }

    private Object getPageObject(String name) {
        return this.getJspContext().getAttribute(name, 1);
    }

    @Override
    public void doTag() throws JspException, IOException {
        JspContext jspContext = this.getJspContext();
        Class resolvingClass = (Class)jspContext.getAttribute("resolvingClass", 2);
        String basePath = (String)jspContext.getAttribute("_basePath", 2);
        ServletConfig servletConfig = (ServletConfig)this.getPageObject("jakarta.servlet.jsp.jspConfig");
        ServletContext servletContext = servletConfig.getServletContext();
        for (Class clazz = resolvingClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            RequestDispatcher dispatcher;
            String template = basePath + TemplateHelper.getAbsolutePath(clazz, this.page, '/');
            if (servletContext.getResource(template) == null || (dispatcher = servletContext.getRequestDispatcher(template)) == null) continue;
            try {
                HttpServletRequest request = (HttpServletRequest)this.getPageObject("jakarta.servlet.jsp.jspRequest");
                HttpServletResponse response = (HttpServletResponse)this.getPageObject("jakarta.servlet.jsp.jspResponse");
                dispatcher.include(request, new Wrapper(response, new PrintWriter(jspContext.getOut())));
            }
            catch (ServletException e) {
                throw new JspException(e);
            }
            return;
        }
        throw new JspException(LocalizationMessages.UNABLE_TO_FIND_PAGE_FOR_RESOLVING_CLASS(this.page, resolvingClass));
    }

    class Wrapper
    extends HttpServletResponseWrapper {
        private final PrintWriter writer;

        Wrapper(HttpServletResponse httpServletResponse, PrintWriter w) {
            super(httpServletResponse);
            this.writer = w;
        }

        @Override
        public PrintWriter getWriter() throws IOException {
            return this.writer;
        }
    }
}

