/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.json.JsonValue;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.annotation.ClientHeaderParam;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptor;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptorFactory;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.glassfish.jersey.internal.util.collection.ImmutableMultivaluedMap;
import org.glassfish.jersey.microprofile.restclient.BeanParamModel;
import org.glassfish.jersey.microprofile.restclient.ClientHeaderParamModel;
import org.glassfish.jersey.microprofile.restclient.ExecutorServiceWrapper;
import org.glassfish.jersey.microprofile.restclient.HeadersContext;
import org.glassfish.jersey.microprofile.restclient.InboundHeadersProvider;
import org.glassfish.jersey.microprofile.restclient.InterceptorInvocationContext;
import org.glassfish.jersey.microprofile.restclient.InterfaceModel;
import org.glassfish.jersey.microprofile.restclient.InterfaceUtil;
import org.glassfish.jersey.microprofile.restclient.ParamModel;
import org.glassfish.jersey.microprofile.restclient.PathParamModel;
import org.glassfish.jersey.microprofile.restclient.ProxyInvocationHandler;
import org.glassfish.jersey.microprofile.restclient.ReflectionUtil;
import org.glassfish.jersey.microprofile.restclient.RestClientBuilderImpl;
import org.glassfish.jersey.microprofile.restclient.RestClientContext;
import org.glassfish.jersey.microprofile.restclient.RestClientModel;
import org.glassfish.jersey.model.Parameter;

class MethodModel {
    private static final String INVOKED_METHOD = "org.eclipse.microprofile.rest.client.invokedMethod";
    private final InterfaceModel interfaceModel;
    private final Method method;
    private final GenericType<?> returnType;
    private final String httpMethod;
    private final String path;
    private final String[] produces;
    private final String[] consumes;
    private final List<ParamModel> parameterModels;
    private final List<ClientHeaderParamModel> clientHeaders;
    private final List<InterceptorInvocationContext.InvocationInterceptor> invocationInterceptors;
    private final RestClientModel subResourceModel;

    static MethodModel from(InterfaceModel interfaceModel, Method method) {
        return new Builder(interfaceModel, method).build();
    }

    private MethodModel(Builder builder) {
        this.method = builder.method;
        this.interfaceModel = builder.interfaceModel;
        this.returnType = builder.returnType;
        this.httpMethod = builder.httpMethod;
        this.path = builder.pathValue;
        this.produces = builder.produces;
        this.consumes = builder.consumes;
        this.parameterModels = builder.parameterModels;
        this.clientHeaders = builder.clientHeaders;
        this.invocationInterceptors = builder.invocationInterceptors;
        this.subResourceModel = this.httpMethod.isEmpty() ? RestClientModel.from(RestClientContext.builder(this.returnType.getRawType()).copyFrom(this.interfaceModel.context()).build()) : null;
    }

    List<InterceptorInvocationContext.InvocationInterceptor> getInvocationInterceptors() {
        return this.invocationInterceptors;
    }

    Object invokeMethod(WebTarget classLevelTarget, Method method, Object[] args) {
        WebTarget methodLevelTarget = classLevelTarget.path(this.path);
        AtomicReference entity = new AtomicReference();
        AtomicReference<WebTarget> webTargetAtomicReference = new AtomicReference<WebTarget>(methodLevelTarget);
        this.parameterModels.stream().filter(parameterModel -> parameterModel.handles(PathParam.class)).forEach(parameterModel -> webTargetAtomicReference.set((WebTarget)parameterModel.handleParameter(webTargetAtomicReference.get(), PathParam.class, args[parameterModel.getParamPosition()])));
        this.parameterModels.stream().filter(ParamModel::isEntity).findFirst().ifPresent(parameterModel -> entity.set(args[parameterModel.getParamPosition()]));
        Form form = this.handleForm(args);
        WebTarget webTarget = webTargetAtomicReference.get();
        if (this.httpMethod.isEmpty()) {
            return this.subResourceProxy(webTarget, this.returnType.getRawType());
        }
        webTarget = this.addQueryParams(webTarget, args);
        webTarget = this.addMatrixParams(webTarget, args);
        MultivaluedMap<String, Object> customHeaders = this.addCustomHeaders(args);
        Object entityToUse = entity.get();
        if (entityToUse == null && !form.asMap().isEmpty()) {
            entityToUse = form;
        }
        if (entityToUse == null) {
            customHeaders.remove("Content-Type");
        }
        Invocation.Builder builder = webTarget.request(this.produces).property(INVOKED_METHOD, method).headers(customHeaders);
        builder = this.addCookies(builder, args);
        Object response = CompletionStage.class.isAssignableFrom(method.getReturnType()) ? this.asynchronousCall(builder, entityToUse, method, customHeaders) : this.synchronousCall(builder, entityToUse, method, customHeaders);
        return response;
    }

    private Form handleForm(Object[] args) {
        Form form = new Form();
        this.parameterModels.stream().filter(parameterModel -> parameterModel.handles(FormParam.class)).forEach(parameterModel -> parameterModel.handleParameter(form, FormParam.class, args[parameterModel.getParamPosition()]));
        return form;
    }

    private Object synchronousCall(Invocation.Builder builder, Object entity, Method method, MultivaluedMap<String, Object> customHeaders) {
        Response response = entity != null && !this.httpMethod.equals(GET.class.getSimpleName()) && !this.httpMethod.equals(DELETE.class.getSimpleName()) ? builder.method(this.httpMethod, Entity.entity(entity, this.getContentType(customHeaders))) : builder.method(this.httpMethod);
        this.evaluateResponse(response, method);
        if (this.returnType.getType().equals(Void.class)) {
            return null;
        }
        if (this.returnType.getType().equals(Response.class)) {
            return response;
        }
        return response.readEntity(this.returnType);
    }

    private CompletableFuture asynchronousCall(Invocation.Builder builder, Object entity, Method method, MultivaluedMap<String, Object> customHeaders) {
        List<AsyncInvocationInterceptor> asyncInterceptors = this.interfaceModel.context().asyncInterceptorFactories().stream().map(AsyncInvocationInterceptorFactory::newInterceptor).collect(Collectors.toList());
        asyncInterceptors.forEach(AsyncInvocationInterceptor::prepareContext);
        ExecutorServiceWrapper.asyncInterceptors.set(asyncInterceptors);
        CompletableFuture result = new CompletableFuture();
        Future<Response> theFuture = entity != null && !this.httpMethod.equals(GET.class.getSimpleName()) && !this.httpMethod.equals(DELETE.class.getSimpleName()) ? builder.async().method(this.httpMethod, Entity.entity(entity, this.getContentType(customHeaders))) : builder.async().method(this.httpMethod);
        CompletableFuture completableFuture = (CompletableFuture)theFuture;
        ((CompletableFuture)completableFuture.thenAccept(response -> {
            asyncInterceptors.forEach(AsyncInvocationInterceptor::removeContext);
            try {
                this.evaluateResponse((Response)response, method);
                if (this.returnType.getType().equals(Void.class)) {
                    result.complete(null);
                } else if (this.returnType.getType().equals(Response.class)) {
                    result.complete(response);
                } else {
                    result.complete(response.readEntity(this.returnType));
                }
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        })).exceptionally(throwable -> {
            asyncInterceptors.forEach(interceptor -> {
                try {
                    interceptor.removeContext();
                }
                catch (Throwable e) {
                    throwable.addSuppressed(e);
                }
            });
            result.completeExceptionally((Throwable)throwable);
            return null;
        });
        return result;
    }

    private String getContentType(MultivaluedMap<String, Object> customHeaders) {
        return (String)customHeaders.getFirst("Content-Type");
    }

    private <T> T subResourceProxy(WebTarget webTarget, Class<T> subResourceType) {
        return (T)Proxy.newProxyInstance(subResourceType.getClassLoader(), new Class[]{subResourceType}, (InvocationHandler)new ProxyInvocationHandler(webTarget, this.subResourceModel));
    }

    private WebTarget addQueryParams(WebTarget webTarget, Object[] args) {
        HashMap queryParams = new HashMap();
        WebTarget toReturn = webTarget;
        this.parameterModels.stream().filter(parameterModel -> parameterModel.handles(QueryParam.class)).forEach(parameterModel -> parameterModel.handleParameter(queryParams, QueryParam.class, args[parameterModel.getParamPosition()]));
        for (Map.Entry entry : queryParams.entrySet()) {
            toReturn = toReturn.queryParam((String)entry.getKey(), (Object[])entry.getValue());
        }
        return toReturn;
    }

    private WebTarget addMatrixParams(WebTarget webTarget, Object[] args) {
        AtomicReference<WebTarget> toReturn = new AtomicReference<WebTarget>(webTarget);
        this.parameterModels.stream().filter(parameterModel -> parameterModel.handles(MatrixParam.class)).forEach(parameterModel -> toReturn.set((WebTarget)parameterModel.handleParameter(toReturn.get(), MatrixParam.class, args[parameterModel.getParamPosition()])));
        return toReturn.get();
    }

    private Invocation.Builder addCookies(Invocation.Builder builder, Object[] args) {
        HashMap cookies = new HashMap();
        Invocation.Builder toReturn = builder;
        this.parameterModels.stream().filter(parameterModel -> parameterModel.handles(CookieParam.class)).forEach(parameterModel -> parameterModel.handleParameter(cookies, CookieParam.class, args[parameterModel.getParamPosition()]));
        for (Map.Entry entry : cookies.entrySet()) {
            toReturn = toReturn.cookie((String)entry.getKey(), (String)entry.getValue());
        }
        return toReturn;
    }

    private MultivaluedMap<String, Object> addCustomHeaders(Object[] args) {
        MultivaluedHashMap<String, Object> result = new MultivaluedHashMap<String, Object>();
        for (Map.Entry entry : this.resolveCustomHeaders(args).entrySet()) {
            ((List)entry.getValue()).forEach(val -> result.add((String)entry.getKey(), val));
        }
        for (String produce : this.produces) {
            result.add("Accept", produce);
        }
        result.putIfAbsent("Content-Type", Collections.singletonList(this.consumes[0]));
        return new MultivaluedHashMap<String, Object>((MultivaluedMap<String, Object>)result);
    }

    private MultivaluedMap<String, String> resolveCustomHeaders(Object[] args) {
        MultivaluedMap<String, String> fromFactory;
        MultivaluedHashMap<String, String> customHeaders = new MultivaluedHashMap<String, String>();
        customHeaders.putAll((Map<String, String>)this.createMultivaluedHeadersMap(this.interfaceModel.getClientHeaders()));
        customHeaders.putAll((Map<String, String>)this.createMultivaluedHeadersMap(this.clientHeaders));
        this.parameterModels.stream().filter(parameterModel -> parameterModel.handles(HeaderParam.class)).forEach(parameterModel -> parameterModel.handleParameter(customHeaders, HeaderParam.class, args[parameterModel.getParamPosition()]));
        MultivaluedHashMap<String, String> inbound = new MultivaluedHashMap<String, String>();
        Optional<HeadersContext> headersContext = HeadersContext.get();
        headersContext.ifPresent(hc -> inbound.putAll((Map<String, String>)hc.inboundHeaders()));
        if (!headersContext.isPresent()) {
            for (InboundHeadersProvider provider : this.interfaceModel.context().inboundHeadersProviders()) {
                inbound.putAll((Map<String, String>)provider.inboundHeaders());
                if (!RestClientBuilderImpl.DefaultInboundHeaderProvider.class.isInstance(provider)) continue;
                fromFactory = ((ClientHeadersFactory)((Object)provider)).update(inbound, customHeaders);
                customHeaders.putAll((Map<String, String>)fromFactory);
            }
        }
        ImmutableMultivaluedMap<String, String> unmodif = new ImmutableMultivaluedMap<String, String>(customHeaders);
        if (this.interfaceModel.getClientHeadersFactory().isPresent()) {
            ClientHeadersFactory factory = this.interfaceModel.getClientHeadersFactory().get();
            fromFactory = factory.update(inbound, unmodif);
            customHeaders.putAll((Map<String, String>)fromFactory);
        }
        return customHeaders;
    }

    private <T> MultivaluedMap<String, String> createMultivaluedHeadersMap(List<ClientHeaderParamModel> clientHeaders) {
        MultivaluedHashMap<String, String> customHeaders = new MultivaluedHashMap<String, String>();
        for (ClientHeaderParamModel clientHeaderParamModel : clientHeaders) {
            if (clientHeaderParamModel.getComputeMethod() == null) {
                customHeaders.put(clientHeaderParamModel.getHeaderName(), (String)((Object)Arrays.asList(clientHeaderParamModel.getHeaderValue())));
                continue;
            }
            try {
                Method method = clientHeaderParamModel.getComputeMethod();
                if (method.isDefault()) {
                    Object instance = ReflectionUtil.createProxyInstance(this.interfaceModel.getRestClientClass());
                    if (method.getParameterCount() > 0) {
                        customHeaders.put(clientHeaderParamModel.getHeaderName(), (String)((Object)MethodModel.createList(method.invoke(instance, clientHeaderParamModel.getHeaderName()))));
                        continue;
                    }
                    customHeaders.put(clientHeaderParamModel.getHeaderName(), (String)((Object)MethodModel.createList(method.invoke(instance, null))));
                    continue;
                }
                if (method.getParameterCount() > 0) {
                    customHeaders.put(clientHeaderParamModel.getHeaderName(), (String)((Object)MethodModel.createList(method.invoke(null, clientHeaderParamModel.getHeaderName()))));
                    continue;
                }
                customHeaders.put(clientHeaderParamModel.getHeaderName(), (String)((Object)MethodModel.createList(method.invoke(null, null))));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                if (!clientHeaderParamModel.isRequired()) continue;
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }
        return customHeaders;
    }

    private static List<String> createList(Object value) {
        if (value instanceof String[]) {
            String[] array = (String[])value;
            return Arrays.asList(array);
        }
        String s = (String)value;
        return Collections.singletonList(s);
    }

    private void evaluateResponse(Response response, Method method) {
        ResponseExceptionMapper<?> lowestMapper = null;
        Object throwable = null;
        for (ResponseExceptionMapper<?> responseExceptionMapper : this.interfaceModel.context().responseExceptionMappers()) {
            Object tmp;
            if (!responseExceptionMapper.handles(response.getStatus(), response.getHeaders()) || lowestMapper != null && throwable != null && lowestMapper.getPriority() <= responseExceptionMapper.getPriority() || (tmp = (lowestMapper = responseExceptionMapper).toThrowable(response)) == null) continue;
            throwable = tmp;
        }
        if (throwable != null) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            for (Class<?> exception : method.getExceptionTypes()) {
                if (!throwable.getClass().isAssignableFrom(exception)) continue;
                throw new WebApplicationException((Throwable)throwable);
            }
        }
    }

    private static String parseHttpMethod(InterfaceModel classModel, Method method) {
        List<Class<?>> httpAnnotations = InterfaceUtil.getHttpAnnotations(method);
        if (httpAnnotations.size() > 1) {
            throw new RestClientDefinitionException("Method can't have more then one annotation of @HttpMethod type. See " + classModel.getRestClientClass().getName() + "::" + method.getName());
        }
        if (httpAnnotations.isEmpty()) {
            return "";
        }
        return httpAnnotations.get(0).getSimpleName();
    }

    private static List<ParamModel> parameterModels(InterfaceModel classModel, Method method) {
        ArrayList<ParamModel> parameterModels = new ArrayList<ParamModel>();
        List jerseyParameters = Parameter.create(classModel.getRestClientClass(), classModel.getRestClientClass(), method, false);
        java.lang.reflect.Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            parameterModels.add(ParamModel.from(classModel, parameters[i].getType(), parameters[i], (Parameter)jerseyParameters.get(i), i));
        }
        return parameterModels;
    }

    private static class Builder {
        private final InterfaceModel interfaceModel;
        private final Method method;
        private GenericType<?> returnType;
        private String httpMethod;
        private String pathValue;
        private String[] produces;
        private String[] consumes;
        private List<ParamModel> parameterModels;
        private List<ClientHeaderParamModel> clientHeaders;
        private List<InterceptorInvocationContext.InvocationInterceptor> invocationInterceptors;

        private Builder(InterfaceModel interfaceModel, Method method) {
            this.interfaceModel = interfaceModel;
            this.method = method;
            this.filterAllInterceptorAnnotations();
        }

        private void filterAllInterceptorAnnotations() {
            this.invocationInterceptors = new ArrayList<InterceptorInvocationContext.InvocationInterceptor>();
            BeanManager beanManager = this.interfaceModel.context().beanManager();
            if (beanManager != null) {
                HashSet<Annotation> interceptorAnnotations = new HashSet<Annotation>();
                for (Annotation annotation : this.method.getAnnotations()) {
                    if (!beanManager.isInterceptorBinding(annotation.annotationType())) continue;
                    interceptorAnnotations.add(annotation);
                }
                interceptorAnnotations.addAll(this.interfaceModel.getInterceptorAnnotations());
                Annotation[] allInterceptorAnnotations = interceptorAnnotations.toArray(new Annotation[0]);
                if (allInterceptorAnnotations.length == 0) {
                    return;
                }
                List<Interceptor<?>> interceptors = beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, allInterceptorAnnotations);
                if (!interceptors.isEmpty()) {
                    for (Interceptor<?> interceptor : interceptors) {
                        Object interceptorInstance = beanManager.getReference(interceptor, interceptor.getBeanClass(), this.interfaceModel.getCreationalContext());
                        this.invocationInterceptors.add(new InterceptorInvocationContext.InvocationInterceptor(interceptorInstance, interceptor));
                    }
                }
            }
        }

        private void returnType(Type returnType) {
            this.returnType = returnType instanceof ParameterizedType && CompletionStage.class.isAssignableFrom((Class)((ParameterizedType)returnType).getRawType()) ? new GenericType(((ParameterizedType)returnType).getActualTypeArguments()[0]) : new GenericType(returnType);
        }

        private void httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        private void pathValue(Path path) {
            this.pathValue = path != null ? path.value() : "";
            this.pathValue = this.pathValue.equals("/") ? "" : this.pathValue;
        }

        private void produces(Produces produces) {
            this.produces = produces == null ? this.interfaceModel.getProduces() : produces.value();
        }

        private void consumes(Consumes consumes) {
            this.consumes = consumes == null ? this.interfaceModel.getConsumes() : consumes.value();
        }

        private void parameters(List<ParamModel> parameterModels) {
            this.parameterModels = parameterModels;
        }

        private void clientHeaders(ClientHeaderParam[] clientHeaderParams) {
            this.clientHeaders = Arrays.stream(clientHeaderParams).map(clientHeaderParam -> new ClientHeaderParamModel(this.interfaceModel.getRestClientClass(), (ClientHeaderParam)clientHeaderParam)).collect(Collectors.toList());
        }

        MethodModel build() {
            this.returnType(this.method.getGenericReturnType());
            this.httpMethod(MethodModel.parseHttpMethod(this.interfaceModel, this.method));
            this.pathValue(this.method.getAnnotation(Path.class));
            this.produces(this.method.getAnnotation(Produces.class));
            this.consumes(this.method.getAnnotation(Consumes.class));
            this.parameters(MethodModel.parameterModels(this.interfaceModel, this.method));
            this.clientHeaders((ClientHeaderParam[])this.method.getAnnotationsByType(ClientHeaderParam.class));
            this.validateParameters();
            this.validateHeaderDuplicityNames();
            if (this.isJsonValue(this.returnType.getType())) {
                this.produces = new String[]{"application/json"};
            }
            this.parameterModels.stream().filter(ParamModel::isEntity).map(ParamModel::getType).filter(this::isJsonValue).findFirst().ifPresent(paramModel -> {
                this.consumes = new String[]{"application/json"};
            });
            return new MethodModel(this);
        }

        private void validateParameters() {
            UriBuilder uriBuilder = UriBuilder.fromUri(this.interfaceModel.getPath()).path(this.pathValue);
            List<String> parameters = InterfaceUtil.getAllMatchingParams(uriBuilder.toTemplate());
            ArrayList<String> methodPathParameters = new ArrayList<String>();
            List pathHandlingParams = this.parameterModels.stream().filter(parameterModel -> parameterModel.handles(PathParam.class)).collect(Collectors.toList());
            for (ParamModel paramModel : pathHandlingParams) {
                if (paramModel instanceof PathParamModel) {
                    methodPathParameters.add(((PathParamModel)paramModel).getPathParamName());
                    continue;
                }
                if (!(paramModel instanceof BeanParamModel)) continue;
                for (ParamModel beanPathParams : ((BeanParamModel)paramModel).getAllParamsWithType(PathParam.class)) {
                    methodPathParameters.add(((PathParamModel)beanPathParams).getPathParamName());
                }
            }
            for (String parameterName : methodPathParameters) {
                if (!parameters.contains(parameterName)) {
                    throw new RestClientDefinitionException("Parameter name " + parameterName + " on " + this.interfaceModel.getRestClientClass().getName() + "::" + this.method.getName() + " doesn't match any @Path variable name.");
                }
                parameters.remove(parameterName);
            }
            if (!parameters.isEmpty()) {
                throw new RestClientDefinitionException("Some variable names does not have matching @PathParam defined on method " + this.interfaceModel.getRestClientClass().getName() + "::" + this.method.getName());
            }
            List entities = this.parameterModels.stream().filter(ParamModel::isEntity).collect(Collectors.toList());
            if (entities.size() > 1) {
                throw new RestClientDefinitionException("You cant have more than 1 entity method parameter! Check " + this.interfaceModel.getRestClientClass().getName() + "::" + this.method.getName());
            }
        }

        private void validateHeaderDuplicityNames() {
            ArrayList<String> names = new ArrayList<String>();
            for (ClientHeaderParamModel clientHeaderParamModel : this.clientHeaders) {
                String headerName = clientHeaderParamModel.getHeaderName();
                if (names.contains(headerName)) {
                    throw new RestClientDefinitionException("Header name cannot be registered more then once on the same target.See " + this.interfaceModel.getRestClientClass().getName());
                }
                names.add(headerName);
            }
        }

        private boolean isJsonValue(Type type2) {
            return type2 instanceof Class && JsonValue.class.isAssignableFrom((Class)type2);
        }
    }
}

