/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MultivaluedMap;
import java.lang.annotation.Annotation;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.glassfish.jersey.microprofile.restclient.BeanClassModel;
import org.glassfish.jersey.microprofile.restclient.ParamHandler;
import org.glassfish.jersey.microprofile.restclient.ParamModel;

class BeanParamModel
extends ParamModel<Object> {
    private static final Map<Class<?>, ParamHandler> PARAM_HANDLERS = new IdentityHashMap();
    private BeanClassModel beanClassModel;

    BeanParamModel(ParamModel.Builder builder) {
        super(builder);
        this.beanClassModel = BeanClassModel.fromClass(this.interfaceModel, (Class)this.getType());
    }

    @Override
    public Object handleParameter(Object requestPart, Class<? extends Annotation> annotationClass, Object instance) {
        ParamHandler handler = PARAM_HANDLERS.get(annotationClass);
        if (null == handler) {
            throw new UnsupportedOperationException(annotationClass.getName() + " is not supported!");
        }
        return handler.handle(this.beanClassModel, requestPart, instance);
    }

    @Override
    public boolean handles(Class<? extends Annotation> annotation) {
        return PARAM_HANDLERS.containsKey(annotation);
    }

    List<ParamModel> getAllParamsWithType(Class<? extends Annotation> paramAnnotation) {
        return this.beanClassModel.getParameterModels().stream().filter(paramModel -> paramModel.handles(paramAnnotation)).collect(Collectors.toList());
    }

    static {
        PARAM_HANDLERS.put(PathParam.class, (model, requestPart, instance) -> model.resolvePath((WebTarget)requestPart, instance));
        PARAM_HANDLERS.put(HeaderParam.class, (model, requestPart, instance) -> model.resolveHeaders((MultivaluedMap)requestPart, instance));
        PARAM_HANDLERS.put(CookieParam.class, (model, requestPart, instance) -> model.resolveCookies((Map)requestPart, instance));
        PARAM_HANDLERS.put(QueryParam.class, (model, requestPart, instance) -> model.resolveQuery((Map)requestPart, instance));
        PARAM_HANDLERS.put(MatrixParam.class, (model, requestPart, instance) -> model.resolveMatrix((WebTarget)requestPart, instance));
        PARAM_HANDLERS.put(FormParam.class, (model, requestPart, instance) -> model.resolveForm((Form)requestPart, instance));
    }
}

