/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.multipart.internal;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Providers;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.BodyPartEntity;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartProperties;
import org.glassfish.jersey.media.multipart.internal.l10n.LocalizationMessages;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.jvnet.mimepull.Header;
import org.jvnet.mimepull.MIMEConfig;
import org.jvnet.mimepull.MIMEMessage;
import org.jvnet.mimepull.MIMEParsingException;
import org.jvnet.mimepull.MIMEPart;

@Consumes(value={"multipart/*"})
@Singleton
@ConstrainedTo(value=RuntimeType.CLIENT)
public class MultiPartReaderClientSide
implements MessageBodyReader<MultiPart> {
    private static final Logger LOGGER = Logger.getLogger(MultiPartReaderClientSide.class.getName());
    private Provider<MessageBodyWorkers> messageBodyWorkers;
    private final MIMEConfig mimeConfig;
    private final int maxParts;

    @Inject
    public MultiPartReaderClientSide(@Context Providers providers, @Context Provider<MessageBodyWorkers> messageBodyWorkers) {
        ContextResolver<MultiPartProperties> contextResolver = providers.getContextResolver(MultiPartProperties.class, MediaType.WILDCARD_TYPE);
        MultiPartProperties properties = null;
        if (contextResolver != null) {
            properties = contextResolver.getContext(this.getClass());
        }
        if (properties == null) {
            properties = new MultiPartProperties();
        }
        this.maxParts = properties.getMaxParts();
        this.messageBodyWorkers = messageBodyWorkers;
        this.mimeConfig = this.createMimeConfig(properties);
    }

    private MIMEConfig createMimeConfig(MultiPartProperties properties) {
        MIMEConfig mimeConfig = new MIMEConfig();
        mimeConfig.setMemoryThreshold(properties.getBufferThreshold());
        String tempDir = properties.getTempDir();
        if (tempDir != null) {
            mimeConfig.setDir(tempDir);
        }
        if (properties.getBufferThreshold() != -1) {
            try {
                File.createTempFile("MIME", null, tempDir != null ? new File(tempDir) : null).delete();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, LocalizationMessages.TEMP_FILE_CANNOT_BE_CREATED(properties.getBufferThreshold()), ioe);
            }
        }
        return mimeConfig;
    }

    @Override
    public boolean isReadable(Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultiPart.class.isAssignableFrom(type2);
    }

    @Override
    public MultiPart readFrom(Class<MultiPart> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream stream) throws IOException, WebApplicationException {
        try {
            return this.readMultiPart(type2, genericType, annotations, mediaType, headers, stream);
        }
        catch (MIMEParsingException mpe) {
            if (mpe.getCause() instanceof IOException) {
                throw (IOException)mpe.getCause();
            }
            throw new BadRequestException(mpe);
        }
    }

    protected MultiPart readMultiPart(Class<MultiPart> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream stream) throws IOException, MIMEParsingException {
        boolean fileNameFix;
        mediaType = MultiPartReaderClientSide.unquoteMediaTypeParameters(mediaType, "boundary");
        MIMEMessage mimeMessage = new MIMEMessage(stream, mediaType.getParameters().get("boundary"), this.mimeConfig);
        boolean formData = MediaTypes.typeEqual(mediaType, MediaType.MULTIPART_FORM_DATA_TYPE);
        MultiPart multiPart = formData ? new FormDataMultiPart() : new MultiPart();
        MessageBodyWorkers workers = this.messageBodyWorkers.get();
        multiPart.setMessageBodyWorkers(workers);
        MultivaluedMap<String, String> multiPartHeaders = multiPart.getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            List values = (List)entry.getValue();
            for (String value : values) {
                multiPartHeaders.add((String)entry.getKey(), value);
            }
        }
        if (!formData) {
            multiPart.setMediaType(mediaType);
            fileNameFix = false;
        } else {
            String userAgent = headers.getFirst("User-Agent");
            fileNameFix = userAgent != null && userAgent.contains(" MSIE ");
        }
        List<MIMEPart> mimeParts = this.getMimeParts(mimeMessage);
        if (mimeParts.size() > this.maxParts) {
            throw new ClientErrorException(Response.Status.REQUEST_ENTITY_TOO_LARGE);
        }
        for (MIMEPart mimePart : mimeParts) {
            BodyPart bodyPart = formData ? new FormDataBodyPart(fileNameFix) : new BodyPart();
            bodyPart.setMessageBodyWorkers(workers);
            for (Header header : mimePart.getAllHeaders()) {
                bodyPart.getHeaders().add(header.getName(), header.getValue());
            }
            try {
                String contentType = bodyPart.getHeaders().getFirst("Content-Type");
                if (contentType != null) {
                    bodyPart.setMediaType(MediaType.valueOf(contentType));
                }
                bodyPart.getContentDisposition();
            }
            catch (IllegalArgumentException ex) {
                throw new BadRequestException(ex);
            }
            bodyPart.setEntity(new BodyPartEntity(mimePart));
            multiPart.getBodyParts().add(bodyPart);
        }
        return multiPart;
    }

    private List<MIMEPart> getMimeParts(MIMEMessage message) {
        try {
            return message.getAttachments();
        }
        catch (MIMEParsingException obtainPartsError) {
            LOGGER.log(Level.FINE, LocalizationMessages.PARSING_ERROR(), obtainPartsError);
            message.close();
            throw obtainPartsError;
        }
    }

    private static MediaType unquoteMediaTypeParameters(MediaType mediaType, String ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return mediaType;
        }
        HashMap<String, String> unquotedParams = new HashMap<String, String>(mediaType.getParameters());
        for (String parameter : parameters) {
            String value = mediaType.getParameters().get(parameter);
            if (value == null || !value.startsWith("\"")) continue;
            value = value.substring(1, value.length() - 1);
            unquotedParams.put(parameter, value);
        }
        return new MediaType(mediaType.getType(), mediaType.getSubtype(), unquotedParams);
    }
}

