/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jettison;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.util.Map;
import org.glassfish.jersey.jettison.JettisonConfig;
import org.glassfish.jersey.jettison.JettisonConfigured;
import org.glassfish.jersey.jettison.JettisonMarshaller;
import org.glassfish.jersey.jettison.JettisonUnmarshaller;
import org.glassfish.jersey.jettison.internal.BaseJsonMarshaller;
import org.glassfish.jersey.jettison.internal.BaseJsonUnmarshaller;
import org.glassfish.jersey.jettison.internal.JettisonJaxbMarshaller;
import org.glassfish.jersey.jettison.internal.JettisonJaxbUnmarshaller;

public final class JettisonJaxbContext
extends JAXBContext
implements JettisonConfigured {
    private JettisonConfig jsonConfiguration;
    private final JAXBContext jaxbContext;

    public JettisonJaxbContext(Class ... classesToBeBound) throws JAXBException {
        this(JettisonConfig.DEFAULT, classesToBeBound);
    }

    public JettisonJaxbContext(JettisonConfig config, Class ... classesToBeBound) throws JAXBException {
        if (config == null) {
            throw new IllegalArgumentException("JSONConfiguration MUST not be null");
        }
        this.jsonConfiguration = config;
        this.jaxbContext = JAXBContext.newInstance(classesToBeBound);
    }

    public JettisonJaxbContext(Class[] classesToBeBound, Map<String, Object> properties) throws JAXBException {
        this.jaxbContext = JAXBContext.newInstance(classesToBeBound, properties);
        if (this.jsonConfiguration == null) {
            this.jsonConfiguration = JettisonConfig.DEFAULT;
        }
    }

    public JettisonJaxbContext(JettisonConfig config, Class[] classesToBeBound, Map<String, Object> properties) throws JAXBException {
        if (config == null) {
            throw new IllegalArgumentException("JSONConfiguration MUST not be null");
        }
        this.jsonConfiguration = config;
        this.jaxbContext = JAXBContext.newInstance(classesToBeBound, properties);
    }

    public JettisonJaxbContext(String contextPath) throws JAXBException {
        this(JettisonConfig.DEFAULT, contextPath);
    }

    public JettisonJaxbContext(JettisonConfig config, String contextPath) throws JAXBException {
        if (config == null) {
            throw new IllegalArgumentException("JSONConfiguration MUST not be null");
        }
        this.jaxbContext = JAXBContext.newInstance(contextPath, Thread.currentThread().getContextClassLoader());
        this.jsonConfiguration = config;
    }

    public JettisonJaxbContext(String contextPath, ClassLoader classLoader) throws JAXBException {
        this.jaxbContext = JAXBContext.newInstance(contextPath, classLoader);
        this.jsonConfiguration = JettisonConfig.DEFAULT;
    }

    public JettisonJaxbContext(String contextPath, ClassLoader classLoader, Map<String, Object> properties) throws JAXBException {
        this.jaxbContext = JAXBContext.newInstance(contextPath, classLoader, properties);
        if (this.jsonConfiguration == null) {
            this.jsonConfiguration = JettisonConfig.DEFAULT;
        }
    }

    public JettisonJaxbContext(JettisonConfig config, String contextPath, ClassLoader classLoader, Map<String, Object> properties) throws JAXBException {
        if (config == null) {
            throw new IllegalArgumentException("JSONConfiguration MUST not be null");
        }
        this.jaxbContext = JAXBContext.newInstance(contextPath, classLoader, properties);
        this.jsonConfiguration = config;
    }

    public static JettisonMarshaller getJSONMarshaller(Marshaller marshaller) {
        if (marshaller instanceof JettisonMarshaller) {
            return (JettisonMarshaller)((Object)marshaller);
        }
        return new BaseJsonMarshaller(marshaller, JettisonConfig.DEFAULT);
    }

    public static JettisonUnmarshaller getJSONUnmarshaller(Unmarshaller unmarshaller) {
        if (unmarshaller instanceof JettisonUnmarshaller) {
            return (JettisonUnmarshaller)((Object)unmarshaller);
        }
        return new BaseJsonUnmarshaller(unmarshaller, JettisonConfig.DEFAULT);
    }

    @Override
    public JettisonConfig getJSONConfiguration() {
        return this.jsonConfiguration;
    }

    public JettisonUnmarshaller createJsonUnmarshaller() throws JAXBException {
        return new JettisonJaxbUnmarshaller(this, this.getJSONConfiguration());
    }

    public JettisonMarshaller createJsonMarshaller() throws JAXBException {
        return new JettisonJaxbMarshaller(this, this.getJSONConfiguration());
    }

    @Override
    public Unmarshaller createUnmarshaller() throws JAXBException {
        return new JettisonJaxbUnmarshaller(this.jaxbContext, this.getJSONConfiguration());
    }

    @Override
    public Marshaller createMarshaller() throws JAXBException {
        return new JettisonJaxbMarshaller(this.jaxbContext, this.getJSONConfiguration());
    }
}

