/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jaxb.internal;

import jakarta.inject.Provider;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Providers;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.UnmarshalException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.jaxb.internal.l10n.LocalizationMessages;
import org.xml.sax.InputSource;

public class JaxbStringReaderProvider {
    private static final Map<Class, JAXBContext> jaxbContexts = new WeakHashMap<Class, JAXBContext>();
    private static final Lock jaxbContextsLock = new ReentrantLock();
    private final Value<ContextResolver<JAXBContext>> mtContext;
    private final Value<ContextResolver<Unmarshaller>> mtUnmarshaller;

    public JaxbStringReaderProvider(final Providers ps) {
        this.mtContext = Values.lazy(new Value<ContextResolver<JAXBContext>>(){

            @Override
            public ContextResolver<JAXBContext> get() {
                return ps.getContextResolver(JAXBContext.class, null);
            }
        });
        this.mtUnmarshaller = Values.lazy(new Value<ContextResolver<Unmarshaller>>(){

            @Override
            public ContextResolver<Unmarshaller> get() {
                return ps.getContextResolver(Unmarshaller.class, null);
            }
        });
    }

    protected final Unmarshaller getUnmarshaller(Class type2) throws JAXBException {
        Unmarshaller u;
        ContextResolver<Unmarshaller> unmarshallerContextResolver = this.mtUnmarshaller.get();
        if (unmarshallerContextResolver != null && (u = unmarshallerContextResolver.getContext(type2)) != null) {
            return u;
        }
        return this.getJAXBContext(type2).createUnmarshaller();
    }

    private JAXBContext getJAXBContext(Class type2) throws JAXBException {
        JAXBContext c;
        ContextResolver<JAXBContext> jaxbContextContextResolver = this.mtContext.get();
        if (jaxbContextContextResolver != null && (c = jaxbContextContextResolver.getContext(type2)) != null) {
            return c;
        }
        return this.getStoredJAXBContext(type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JAXBContext getStoredJAXBContext(Class type2) throws JAXBException {
        jaxbContextsLock.lock();
        try {
            JAXBContext c = jaxbContexts.get(type2);
            if (c == null) {
                c = JAXBContext.newInstance(type2);
                jaxbContexts.put(type2, c);
            }
            JAXBContext jAXBContext = c;
            return jAXBContext;
        }
        finally {
            jaxbContextsLock.unlock();
        }
    }

    public static class RootElementProvider
    extends JaxbStringReaderProvider
    implements ParamConverterProvider {
        private final Provider<SAXParserFactory> spfProvider;

        public RootElementProvider(@Context Provider<SAXParserFactory> spfProvider, @Context Providers ps) {
            super(ps);
            this.spfProvider = spfProvider;
        }

        @Override
        public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
            boolean supported;
            boolean bl = supported = rawType.getAnnotation(XmlRootElement.class) != null || rawType.getAnnotation(XmlType.class) != null;
            if (!supported) {
                return null;
            }
            return new ParamConverter<T>(){

                @Override
                public T fromString(String value) {
                    try {
                        SAXSource source = new SAXSource(spfProvider.get().newSAXParser().getXMLReader(), new InputSource(new StringReader(value)));
                        Unmarshaller u = this.getUnmarshaller(rawType);
                        if (rawType.isAnnotationPresent(XmlRootElement.class)) {
                            return rawType.cast(u.unmarshal(source));
                        }
                        return u.unmarshal(source, rawType).getValue();
                    }
                    catch (UnmarshalException ex) {
                        throw new ExtractorException(LocalizationMessages.ERROR_UNMARSHALLING_JAXB(rawType), ex);
                    }
                    catch (JAXBException ex) {
                        throw new ProcessingException(LocalizationMessages.ERROR_UNMARSHALLING_JAXB(rawType), ex);
                    }
                    catch (Exception ex) {
                        throw new ProcessingException(LocalizationMessages.ERROR_UNMARSHALLING_JAXB(rawType), ex);
                    }
                }

                @Override
                public String toString(T value) throws IllegalArgumentException {
                    return "test";
                }
            };
        }
    }
}

