/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.ext.cdi1x.internal;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glassfish.hk2.api.ClassAnalyzer;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.jersey.ext.cdi1x.internal.CdiComponentProvider;
import org.glassfish.jersey.ext.cdi1x.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.collection.Views;

public final class InjecteeSkippingAnalyzer
implements ClassAnalyzer {
    private final ClassAnalyzer defaultAnalyzer;
    private final Map<Class<?>, Set<Method>> methodsToSkip;
    private final Map<Class<?>, Set<Field>> fieldsToSkip;
    private final BeanManager beanManager;
    private final CdiComponentProvider cdiComponentProvider;

    public InjecteeSkippingAnalyzer(ClassAnalyzer defaultAnalyzer, Map<Class<?>, Set<Method>> methodsToSkip, Map<Class<?>, Set<Field>> fieldsToSkip, BeanManager beanManager) {
        this.defaultAnalyzer = defaultAnalyzer;
        this.methodsToSkip = methodsToSkip;
        this.fieldsToSkip = fieldsToSkip;
        this.beanManager = beanManager;
        this.cdiComponentProvider = beanManager.getExtension(CdiComponentProvider.class);
    }

    @Override
    public <T> Constructor<T> getConstructor(Class<T> type2) throws MultiException, NoSuchMethodException {
        throw new IllegalStateException(LocalizationMessages.CDI_CLASS_ANALYZER_MISUSED());
    }

    @Override
    public <T> Set<Method> getInitializerMethods(Class<T> type2) throws MultiException {
        Set<Method> originalMethods = this.defaultAnalyzer.getInitializerMethods(type2);
        Set skippedMethods = this.getMembersToSkip(type2, this.methodsToSkip);
        return Views.setDiffView(originalMethods, skippedMethods);
    }

    @Override
    public <T> Set<Field> getFields(Class<T> type2) throws MultiException {
        Set<Field> originalFields = this.defaultAnalyzer.getFields(type2);
        Set<Field> skippedFields = this.getMembersToSkip(type2, this.fieldsToSkip);
        this.addCdiInjectedFieldsToSkip(skippedFields, originalFields);
        return Views.setDiffView(originalFields, skippedFields);
    }

    @Override
    public <T> Method getPostConstructMethod(Class<T> type2) throws MultiException {
        throw new IllegalStateException(LocalizationMessages.CDI_CLASS_ANALYZER_MISUSED());
    }

    @Override
    public <T> Method getPreDestroyMethod(Class<T> type2) throws MultiException {
        throw new IllegalStateException(LocalizationMessages.CDI_CLASS_ANALYZER_MISUSED());
    }

    private <M extends Member> Set<M> getMembersToSkip(Class<?> type2, Map<Class<?>, Set<M>> skippedMembers) {
        Set<M> directResult = skippedMembers.get(type2);
        if (directResult != null) {
            return directResult;
        }
        HashSet compositeResult = new HashSet();
        for (Map.Entry<Class<?>, Set<M>> type2Method : skippedMembers.entrySet()) {
            if (!type2Method.getKey().isAssignableFrom(type2)) continue;
            compositeResult.addAll(type2Method.getValue());
        }
        return compositeResult;
    }

    private void addCdiInjectedFieldsToSkip(Set<Field> skippedFields, Set<Field> originalFields) {
        for (Field field : originalFields) {
            if (field.getAnnotation(Inject.class) == null || this.cdiComponentProvider.isHk2ProvidedType(field.getType())) continue;
            skippedFields.add(field);
        }
    }
}

