/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.config.validators;

import com.sun.enterprise.config.serverbeans.ResourcePool;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.glassfish.connectors.config.validators.ConnectionPoolErrorMessages;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.jdbc.config.validators.JdbcConnectionPoolConstraint;

public class JdbcConnectionPoolValidator
implements ConstraintValidator<JdbcConnectionPoolConstraint, ResourcePool> {
    protected ConnectionPoolErrorMessages poolFaults;

    @Override
    public void initialize(JdbcConnectionPoolConstraint constraint) {
        this.poolFaults = constraint.value();
    }

    @Override
    public boolean isValid(ResourcePool pool, ConstraintValidatorContext constraintValidatorContext) {
        JdbcConnectionPool jdbcPool;
        if (this.poolFaults == ConnectionPoolErrorMessages.MAX_STEADY_INVALID && pool instanceof JdbcConnectionPool) {
            jdbcPool = (JdbcConnectionPool)pool;
            String maxPoolSize = jdbcPool.getMaxPoolSize();
            String steadyPoolSize = jdbcPool.getSteadyPoolSize();
            if (steadyPoolSize == null) {
                steadyPoolSize = "8";
            }
            if (maxPoolSize == null) {
                maxPoolSize = "32";
            }
            if (Integer.parseInt(maxPoolSize) < Integer.parseInt(steadyPoolSize)) {
                return false;
            }
        }
        if (this.poolFaults == ConnectionPoolErrorMessages.STMT_WRAPPING_DISABLED && pool instanceof JdbcConnectionPool) {
            jdbcPool = (JdbcConnectionPool)pool;
            String stmtCacheSize = jdbcPool.getStatementCacheSize();
            String stmtLeakTimeout = jdbcPool.getStatementLeakTimeoutInSeconds();
            if (jdbcPool.getSqlTraceListeners() != null && !Boolean.valueOf(jdbcPool.getWrapJdbcObjects()).booleanValue()) {
                return false;
            }
            if (stmtCacheSize != null && Integer.parseInt(stmtCacheSize) != 0 && !Boolean.valueOf(jdbcPool.getWrapJdbcObjects()).booleanValue()) {
                return false;
            }
            if (stmtLeakTimeout != null && Integer.parseInt(stmtLeakTimeout) != 0 && !Boolean.parseBoolean(jdbcPool.getWrapJdbcObjects())) {
                return false;
            }
            if (Boolean.valueOf(jdbcPool.getStatementLeakReclaim()).booleanValue() && !Boolean.valueOf(jdbcPool.getWrapJdbcObjects()).booleanValue()) {
                return false;
            }
        }
        if (this.poolFaults == ConnectionPoolErrorMessages.TABLE_NAME_MANDATORY && pool instanceof JdbcConnectionPool && Boolean.valueOf((jdbcPool = (JdbcConnectionPool)pool).getIsConnectionValidationRequired()).booleanValue() && "table".equals(jdbcPool.getConnectionValidationMethod()) && (jdbcPool.getValidationTableName() == null || jdbcPool.getValidationTableName().equals(""))) {
            return false;
        }
        if (this.poolFaults == ConnectionPoolErrorMessages.CUSTOM_VALIDATION_CLASS_NAME_MANDATORY && pool instanceof JdbcConnectionPool && Boolean.valueOf((jdbcPool = (JdbcConnectionPool)pool).getIsConnectionValidationRequired()).booleanValue() && "custom-validation".equals(jdbcPool.getConnectionValidationMethod()) && (jdbcPool.getValidationClassname() == null || jdbcPool.getValidationClassname().equals(""))) {
            return false;
        }
        if (this.poolFaults == ConnectionPoolErrorMessages.RES_TYPE_MANDATORY && pool instanceof JdbcConnectionPool) {
            jdbcPool = (JdbcConnectionPool)pool;
            String resType = jdbcPool.getResType();
            String dsClassName = jdbcPool.getDatasourceClassname();
            String driverClassName = jdbcPool.getDriverClassname();
            if (resType == null) {
                if ((dsClassName == null || dsClassName.equals("")) && (driverClassName == null || driverClassName.equals(""))) {
                    return false;
                }
                if (dsClassName != null && driverClassName != null) {
                    return false;
                }
            } else if (resType.equals("javax.sql.DataSource") || resType.equals("javax.sql.ConnectionPoolDataSource") || resType.equals("javax.sql.XADataSource") ? dsClassName == null || dsClassName.equals("") : resType.equals("java.sql.Driver") && (driverClassName == null || driverClassName.equals(""))) {
                return false;
            }
        }
        return true;
    }
}

