/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.runlevel.internal;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.ChangeableRunLevelFuture;
import org.glassfish.hk2.runlevel.ErrorInformation;
import org.glassfish.hk2.runlevel.ProgressStartedListener;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.hk2.runlevel.RunLevelListener;
import org.glassfish.hk2.runlevel.Sorter;
import org.glassfish.hk2.runlevel.internal.AsyncRunLevelContext;
import org.glassfish.hk2.runlevel.internal.CurrentTaskFutureWrapper;
import org.glassfish.hk2.runlevel.internal.ErrorInformationImpl;
import org.glassfish.hk2.runlevel.internal.WasCancelledException;
import org.glassfish.hk2.runlevel.internal.WouldBlockException;
import org.glassfish.hk2.runlevel.utilities.Utilities;

public class CurrentTaskFuture
implements ChangeableRunLevelFuture {
    private final ReentrantLock lock = new ReentrantLock();
    private final AsyncRunLevelContext asyncContext;
    private final Executor executor;
    private final ServiceLocator locator;
    private int proposedLevel;
    private final boolean useThreads;
    private final List<ServiceHandle<RunLevelListener>> allListenerHandles;
    private final List<ServiceHandle<ProgressStartedListener>> allProgressStartedHandles;
    private final List<ServiceHandle<Sorter>> allSorterHandles;
    private final int maxThreads;
    private final Timer timer;
    private final long cancelTimeout;
    private UpAllTheWay upAllTheWay;
    private DownAllTheWay downAllTheWay;
    private boolean done = false;
    private boolean cancelled = false;
    private boolean inCallback = false;

    CurrentTaskFuture(AsyncRunLevelContext asyncContext, Executor executor, ServiceLocator locator, int proposedLevel, int maxThreads, boolean useThreads, long cancelTimeout, Timer timer) {
        this.asyncContext = asyncContext;
        this.executor = executor;
        this.locator = locator;
        this.proposedLevel = proposedLevel;
        this.useThreads = useThreads;
        this.maxThreads = maxThreads;
        this.cancelTimeout = cancelTimeout;
        this.timer = timer;
        int currentLevel = asyncContext.getCurrentLevel();
        this.allListenerHandles = locator.getAllServiceHandles(RunLevelListener.class, new Annotation[0]);
        this.allProgressStartedHandles = locator.getAllServiceHandles(ProgressStartedListener.class, new Annotation[0]);
        this.allSorterHandles = locator.getAllServiceHandles(Sorter.class, new Annotation[0]);
        if (currentLevel == proposedLevel) {
            this.done = true;
        } else if (currentLevel < proposedLevel) {
            this.upAllTheWay = new UpAllTheWay(proposedLevel, this, this.allListenerHandles, this.allSorterHandles, maxThreads, useThreads, cancelTimeout);
        } else {
            this.downAllTheWay = new DownAllTheWay(proposedLevel, this, this.allListenerHandles);
        }
    }

    void go() {
        DownAllTheWay localDownAllTheWay;
        UpAllTheWay localUpAllTheWay;
        this.lock.lock();
        try {
            localUpAllTheWay = this.upAllTheWay;
            localDownAllTheWay = this.downAllTheWay;
        }
        finally {
            this.lock.unlock();
        }
        if (localUpAllTheWay != null || localDownAllTheWay != null) {
            int currentLevel = this.asyncContext.getCurrentLevel();
            this.invokeOnProgressStarted(this, currentLevel, this.allProgressStartedHandles);
        }
        this.go(localUpAllTheWay, localDownAllTheWay);
    }

    private void go(UpAllTheWay localUpAllTheWay, DownAllTheWay localDownAllTheWay) {
        if (localUpAllTheWay != null) {
            localUpAllTheWay.go();
        } else if (localDownAllTheWay != null) {
            if (this.useThreads) {
                this.executor.execute(localDownAllTheWay);
            } else {
                localDownAllTheWay.run();
            }
        } else {
            this.asyncContext.jobDone();
        }
    }

    @Override
    public boolean isUp() {
        this.lock.lock();
        try {
            if (this.upAllTheWay != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isDown() {
        this.lock.lock();
        try {
            if (this.downAllTheWay != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            block14: {
                block13: {
                    this.asyncContext.lock.lock();
                    try {
                        this.lock.lock();
                        if (!this.done) break block13;
                        boolean bl = false;
                        this.lock.unlock();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        this.lock.unlock();
                        throw throwable;
                    }
                }
                if (!this.cancelled) break block14;
                boolean bl = false;
                this.lock.unlock();
                return bl;
            }
            this.cancelled = true;
            if (this.upAllTheWay != null) {
                this.upAllTheWay.cancel();
            } else if (this.downAllTheWay != null) {
                this.downAllTheWay.cancel();
            }
            boolean bl = true;
            this.lock.unlock();
            return bl;
        }
        finally {
            this.asyncContext.lock.unlock();
        }
    }

    @Override
    public boolean isCancelled() {
        this.lock.lock();
        try {
            boolean bl = this.cancelled;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isDone() {
        this.lock.lock();
        try {
            boolean bl = this.done;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getProposedLevel() {
        this.lock.lock();
        try {
            int n = this.proposedLevel;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int changeProposedLevel(int proposedLevel) {
        int oldProposedVal;
        boolean needGo;
        block12: {
            needGo = false;
            this.lock.lock();
            try {
                if (this.done) {
                    throw new IllegalStateException("Cannot change the proposed level of a future that is already complete");
                }
                if (!this.inCallback) {
                    throw new IllegalStateException("changeProposedLevel must only be called from inside a RunLevelListener callback method");
                }
                oldProposedVal = this.proposedLevel;
                int currentLevel = this.asyncContext.getCurrentLevel();
                this.proposedLevel = proposedLevel;
                if (this.upAllTheWay != null) {
                    if (currentLevel <= proposedLevel) {
                        this.upAllTheWay.setGoingTo(proposedLevel, false);
                    } else {
                        this.upAllTheWay.setGoingTo(currentLevel, true);
                        this.upAllTheWay = null;
                        this.downAllTheWay = new DownAllTheWay(proposedLevel, this, this.allListenerHandles);
                        needGo = true;
                    }
                    break block12;
                }
                if (this.downAllTheWay != null) {
                    if (currentLevel >= proposedLevel) {
                        this.downAllTheWay.setGoingTo(proposedLevel, false);
                    } else {
                        this.downAllTheWay.setGoingTo(currentLevel, true);
                        this.downAllTheWay = null;
                        this.upAllTheWay = new UpAllTheWay(proposedLevel, this, this.allListenerHandles, this.allSorterHandles, this.maxThreads, this.useThreads, this.cancelTimeout);
                        needGo = true;
                    }
                    break block12;
                }
                throw new AssertionError((Object)"Can not determine previous job");
            }
            finally {
                this.lock.unlock();
            }
        }
        if (needGo) {
            this.go(this.upAllTheWay, this.downAllTheWay);
        }
        return oldProposedVal;
    }

    private void setInCallback(boolean inCallback) {
        this.lock.lock();
        try {
            this.inCallback = inCallback;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            throw new AssertionError((Object)te);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        AllTheWay allTheWay = null;
        this.lock.lock();
        try {
            if (this.upAllTheWay != null) {
                allTheWay = this.upAllTheWay;
            } else if (this.downAllTheWay != null) {
                allTheWay = this.downAllTheWay;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (allTheWay == null) {
            return null;
        }
        Boolean result = null;
        try {
            while ((result = allTheWay.waitForResult(timeout, unit)) == null) {
                this.lock.lock();
                try {
                    if (this.upAllTheWay != null) {
                        allTheWay = this.upAllTheWay;
                        continue;
                    }
                    if (this.downAllTheWay == null) continue;
                    allTheWay = this.downAllTheWay;
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (!result.booleanValue()) {
                throw new TimeoutException();
            }
            this.lock.lock();
            try {
                this.done = true;
            }
            finally {
                this.lock.unlock();
            }
            return null;
        }
        catch (MultiException me) {
            this.lock.lock();
            try {
                this.done = true;
            }
            finally {
                this.lock.unlock();
            }
            throw new ExecutionException(me);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeOnProgress(ChangeableRunLevelFuture job, int level, List<ServiceHandle<RunLevelListener>> listeners) {
        this.setInCallback(true);
        try {
            for (ServiceHandle<RunLevelListener> listener : listeners) {
                try {
                    RunLevelListener rll = listener.getService();
                    if (rll == null) continue;
                    rll.onProgress(job, level);
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            this.setInCallback(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeOnProgressStarted(ChangeableRunLevelFuture job, int level, List<ServiceHandle<ProgressStartedListener>> listeners) {
        this.setInCallback(true);
        try {
            for (ServiceHandle<ProgressStartedListener> listener : listeners) {
                try {
                    ProgressStartedListener psl = listener.getService();
                    if (psl == null) continue;
                    psl.onProgressStarting(job, level);
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            this.setInCallback(false);
        }
    }

    private static void invokeOnCancelled(CurrentTaskFuture job, int levelAchieved, List<ServiceHandle<RunLevelListener>> listeners) {
        for (ServiceHandle<RunLevelListener> listener : listeners) {
            try {
                RunLevelListener rll = listener.getService();
                if (rll == null) continue;
                rll.onCancelled(new CurrentTaskFutureWrapper(job), levelAchieved);
            }
            catch (Throwable throwable) {}
        }
    }

    private static ErrorInformation invokeOnError(CurrentTaskFuture job, Throwable th, ErrorInformation.ErrorAction action, List<ServiceHandle<RunLevelListener>> listeners, Descriptor descriptor) {
        ErrorInformationImpl errorInfo = new ErrorInformationImpl(th, action, descriptor);
        for (ServiceHandle<RunLevelListener> listener : listeners) {
            try {
                RunLevelListener rll = listener.getService();
                if (rll == null) continue;
                rll.onError(new CurrentTaskFutureWrapper(job), errorInfo);
            }
            catch (Throwable throwable) {}
        }
        return errorInfo;
    }

    static final boolean isWouldBlock(Throwable th) {
        return CurrentTaskFuture.isACertainException(th, WouldBlockException.class);
    }

    private static final boolean isWasCancelled(Throwable th) {
        return CurrentTaskFuture.isACertainException(th, WasCancelledException.class);
    }

    private static final boolean isACertainException(Throwable th, Class<? extends Throwable> type2) {
        for (Throwable cause = th; cause != null; cause = cause.getCause()) {
            if (cause instanceof MultiException) {
                MultiException me = (MultiException)cause;
                for (Throwable innerMulti : me.getErrors()) {
                    if (!CurrentTaskFuture.isACertainException(innerMulti, type2)) continue;
                    return true;
                }
                continue;
            }
            if (!type2.isAssignableFrom(cause.getClass())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "CurrentTaskFuture(proposedLevel=" + this.proposedLevel + "," + System.identityHashCode(this) + ")";
    }

    private class UpAllTheWay
    implements AllTheWay {
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();
        private int goingTo;
        private final int maxThreads;
        private final boolean useThreads;
        private final CurrentTaskFuture future;
        private final List<ServiceHandle<RunLevelListener>> listeners;
        private final List<ServiceHandle<Sorter>> sorters;
        private final long cancelTimeout;
        private int workingOn;
        private UpOneLevel currentJob;
        private boolean cancelled = false;
        private boolean done = false;
        private boolean repurposed = false;
        private MultiException exception = null;

        private UpAllTheWay(int goingTo, CurrentTaskFuture future, List<ServiceHandle<RunLevelListener>> listeners, List<ServiceHandle<Sorter>> sorters, int maxThreads, boolean useThreads, long cancelTimeout) {
            this.goingTo = goingTo;
            this.future = future;
            this.listeners = listeners;
            this.maxThreads = maxThreads;
            this.useThreads = useThreads;
            this.sorters = sorters;
            this.cancelTimeout = cancelTimeout;
            this.workingOn = CurrentTaskFuture.this.asyncContext.getCurrentLevel();
        }

        private void cancel() {
            this.lock.lock();
            try {
                this.cancelled = true;
                CurrentTaskFuture.this.asyncContext.levelCancelled();
                this.currentJob.cancel();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean waitForResult(long timeout, TimeUnit unit) throws InterruptedException, MultiException {
            this.lock.lock();
            try {
                long elapsedTime;
                for (long totalWaitTimeMillis = TimeUnit.MILLISECONDS.convert(timeout, unit); totalWaitTimeMillis > 0L && !this.done && !this.repurposed; totalWaitTimeMillis -= elapsedTime) {
                    long startTime = System.currentTimeMillis();
                    this.condition.await(totalWaitTimeMillis, TimeUnit.MILLISECONDS);
                    elapsedTime = System.currentTimeMillis() - startTime;
                }
                if (this.repurposed) {
                    Boolean bl = null;
                    return bl;
                }
                if (this.done && this.exception != null) {
                    throw this.exception;
                }
                Boolean bl = this.done;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        private void setGoingTo(int goingTo, boolean repurposed) {
            this.lock.lock();
            try {
                this.goingTo = goingTo;
                if (repurposed) {
                    this.repurposed = true;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private void go() {
            if (this.useThreads) {
                this.lock.lock();
                try {
                    ++this.workingOn;
                    if (this.workingOn > this.goingTo) {
                        if (!this.repurposed) {
                            CurrentTaskFuture.this.asyncContext.jobDone();
                            this.done = true;
                        }
                        this.condition.signalAll();
                        return;
                    }
                    this.currentJob = new UpOneLevel(this.workingOn, this, this.future, this.listeners, this.sorters, this.maxThreads, this.cancelTimeout);
                    CurrentTaskFuture.this.executor.execute(this.currentJob);
                    return;
                }
                finally {
                    this.lock.unlock();
                }
            }
            ++this.workingOn;
            while (this.workingOn <= this.goingTo) {
                this.lock.lock();
                try {
                    if (this.done) break;
                    this.currentJob = new UpOneLevel(this.workingOn, this, this.future, this.listeners, this.sorters, 0, this.cancelTimeout);
                }
                finally {
                    this.lock.unlock();
                }
                this.currentJob.run();
                ++this.workingOn;
            }
            this.lock.lock();
            try {
                if (this.done) {
                    return;
                }
                if (!this.repurposed) {
                    CurrentTaskFuture.this.asyncContext.jobDone();
                    this.done = true;
                }
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void currentJobComplete(MultiException accumulatedExceptions) {
            CurrentTaskFuture.this.asyncContext.clearErrors();
            if (accumulatedExceptions != null) {
                DownAllTheWay downer = new DownAllTheWay(this.workingOn - 1, null, null);
                downer.run();
                this.lock.lock();
                try {
                    this.done = true;
                    this.exception = accumulatedExceptions;
                    this.condition.signalAll();
                    CurrentTaskFuture.this.asyncContext.jobDone();
                }
                finally {
                    this.lock.unlock();
                }
                return;
            }
            DownAllTheWay downer = null;
            this.lock.lock();
            try {
                if (this.cancelled) {
                    downer = new DownAllTheWay(this.workingOn - 1, null, null);
                }
            }
            finally {
                this.lock.unlock();
            }
            if (downer != null) {
                downer.run();
                CurrentTaskFuture.invokeOnCancelled(this.future, this.workingOn - 1, this.listeners);
                this.lock.lock();
                try {
                    this.done = true;
                    this.condition.signalAll();
                    CurrentTaskFuture.this.asyncContext.jobDone();
                    return;
                }
                finally {
                    this.lock.unlock();
                }
            }
            CurrentTaskFuture.this.asyncContext.setCurrentLevel(this.workingOn);
            CurrentTaskFuture.this.invokeOnProgress(this.future, this.workingOn, this.listeners);
            if (this.useThreads) {
                this.go();
            }
        }
    }

    private class DownAllTheWay
    implements Runnable,
    AllTheWay {
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition lockCondition = this.lock.newCondition();
        private int goingTo;
        private CurrentTaskFuture future;
        private final List<ServiceHandle<RunLevelListener>> listeners;
        private int workingOn;
        private boolean cancelled = false;
        private boolean done = false;
        private boolean repurposed = false;
        private Throwable lastError = null;
        private ActiveDescriptor<?> lastErrorDescriptor = null;
        private List<ActiveDescriptor<?>> queue = Collections.emptyList();
        private ReentrantLock queueLock = new ReentrantLock();
        private Condition queueCondition = this.queueLock.newCondition();
        private boolean downHardCancelled = false;
        private HardCancelDownTimer hardCancelDownTimer = null;

        public DownAllTheWay(int goingTo, CurrentTaskFuture future, List<ServiceHandle<RunLevelListener>> listeners) {
            this.goingTo = goingTo;
            this.future = future;
            this.listeners = listeners;
            this.workingOn = future == null ? CurrentTaskFuture.this.asyncContext.getCurrentLevel() + 1 : CurrentTaskFuture.this.asyncContext.getCurrentLevel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel() {
            Condition localQueueCondition;
            ReentrantLock localQueueLock;
            List<ActiveDescriptor<?>> localQueue;
            this.lock.lock();
            try {
                if (this.cancelled) {
                    return;
                }
                this.cancelled = true;
                if (this.done) {
                    return;
                }
                localQueue = this.queue;
                localQueueLock = this.queueLock;
                localQueueCondition = this.queueCondition;
            }
            finally {
                this.lock.unlock();
            }
            this.queueLock.lock();
            try {
                if (localQueue.isEmpty()) {
                    return;
                }
                this.hardCancelDownTimer = new HardCancelDownTimer(this, localQueue, localQueueLock, localQueueCondition);
                CurrentTaskFuture.this.timer.schedule((TimerTask)this.hardCancelDownTimer, CurrentTaskFuture.this.cancelTimeout, CurrentTaskFuture.this.cancelTimeout);
            }
            finally {
                this.queueLock.unlock();
            }
        }

        private void setGoingTo(int goingTo, boolean repurposed) {
            this.lock.lock();
            try {
                this.goingTo = goingTo;
                if (repurposed) {
                    this.repurposed = true;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private int getGoingTo() {
            this.lock.lock();
            try {
                int n = this.goingTo;
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.workingOn > this.getGoingTo()) {
                boolean runOnCancelled;
                boolean localCancelled;
                this.lock.lock();
                try {
                    localCancelled = this.cancelled;
                    runOnCancelled = this.cancelled && this.future != null;
                }
                finally {
                    this.lock.unlock();
                }
                if (runOnCancelled) {
                    CurrentTaskFuture.invokeOnCancelled(this.future, this.workingOn, this.listeners);
                }
                this.lock.lock();
                try {
                    if (localCancelled) {
                        CurrentTaskFuture.this.asyncContext.jobDone();
                        this.done = true;
                        this.lockCondition.signalAll();
                        return;
                    }
                }
                finally {
                    this.lock.unlock();
                }
                int proceedingTo = this.workingOn - 1;
                CurrentTaskFuture.this.asyncContext.setCurrentLevel(proceedingTo);
                List<ActiveDescriptor<?>> localQueue = CurrentTaskFuture.this.asyncContext.getOrderedListOfServicesAtLevel(this.workingOn);
                ReentrantLock localQueueLock = new ReentrantLock();
                Condition localQueueCondition = localQueueLock.newCondition();
                this.lock.lock();
                try {
                    this.queue = localQueue;
                    this.queueLock = localQueueLock;
                    this.queueCondition = localQueueCondition;
                }
                finally {
                    this.lock.unlock();
                }
                ErrorInformation errorInfo = null;
                this.queueLock.lock();
                try {
                    do {
                        DownQueueRunner currentRunner = new DownQueueRunner(this.queueLock, this.queueCondition, this.queue, this, CurrentTaskFuture.this.locator);
                        CurrentTaskFuture.this.executor.execute(currentRunner);
                        this.lastError = null;
                        while (true) {
                            if (!this.queue.isEmpty() && this.lastError == null && !this.downHardCancelled) {
                                try {
                                    this.queueCondition.await();
                                }
                                catch (InterruptedException ie) {
                                    throw new RuntimeException(ie);
                                }
                            }
                            if (this.downHardCancelled) {
                                currentRunner.caput = true;
                            }
                            if (this.lastError != null && this.future != null) {
                                errorInfo = CurrentTaskFuture.invokeOnError(this.future, this.lastError, ErrorInformation.ErrorAction.IGNORE, this.listeners, this.lastErrorDescriptor);
                            }
                            this.lastError = null;
                            this.lastErrorDescriptor = null;
                            if (this.queue.isEmpty() || this.downHardCancelled) break;
                        }
                        this.downHardCancelled = false;
                    } while (!this.queue.isEmpty());
                    if (this.hardCancelDownTimer != null) {
                        this.hardCancelDownTimer.cancel();
                    }
                }
                finally {
                    this.queueLock.unlock();
                }
                this.lock.lock();
                try {
                    this.queue = Collections.emptyList();
                    this.queueLock = new ReentrantLock();
                    this.queueCondition = this.queueLock.newCondition();
                }
                finally {
                    this.lock.unlock();
                }
                if (errorInfo != null && ErrorInformation.ErrorAction.GO_TO_NEXT_LOWER_LEVEL_AND_STOP.equals((Object)errorInfo.getAction())) {
                    this.lock.lock();
                    try {
                        this.goingTo = this.workingOn;
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                --this.workingOn;
                if (this.future == null) continue;
                CurrentTaskFuture.this.invokeOnProgress(this.future, proceedingTo, this.listeners);
            }
            if (this.future == null) {
                return;
            }
            this.lock.lock();
            try {
                if (!this.repurposed) {
                    CurrentTaskFuture.this.asyncContext.jobDone();
                    this.done = true;
                }
                this.lockCondition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean waitForResult(long timeout, TimeUnit unit) throws InterruptedException, MultiException {
            this.lock.lock();
            try {
                long elapsedTime;
                for (long totalWaitTimeMillis = TimeUnit.MILLISECONDS.convert(timeout, unit); totalWaitTimeMillis > 0L && !this.done && !this.repurposed; totalWaitTimeMillis -= elapsedTime) {
                    long startTime = System.currentTimeMillis();
                    this.lockCondition.await(totalWaitTimeMillis, TimeUnit.MILLISECONDS);
                    elapsedTime = System.currentTimeMillis() - startTime;
                }
                if (this.repurposed) {
                    Boolean bl = null;
                    return bl;
                }
                Boolean bl = this.done;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static interface AllTheWay {
        public Boolean waitForResult(long var1, TimeUnit var3) throws InterruptedException, MultiException;
    }

    private static class DownQueueRunner
    implements Runnable {
        private final ReentrantLock queueLock;
        private final Condition queueCondition;
        private final List<ActiveDescriptor<?>> queue;
        private final DownAllTheWay parent;
        private final ServiceLocator locator;
        private boolean caput;

        private DownQueueRunner(ReentrantLock queueLock, Condition queueCondition, List<ActiveDescriptor<?>> queue, DownAllTheWay parent, ServiceLocator locator) {
            this.queueLock = queueLock;
            this.queueCondition = queueCondition;
            this.queue = queue;
            this.parent = parent;
            this.locator = locator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                ActiveDescriptor<?> job;
                this.queueLock.lock();
                try {
                    if (this.caput) {
                        return;
                    }
                    if (this.queue.isEmpty()) {
                        this.queueCondition.signal();
                        return;
                    }
                    job = this.queue.get(0);
                }
                finally {
                    this.queueLock.unlock();
                }
                try {
                    this.locator.getServiceHandle(job).destroy();
                    continue;
                }
                catch (Throwable th) {
                    this.queueLock.lock();
                    try {
                        this.parent.lastError = th;
                        this.parent.lastErrorDescriptor = job;
                        this.queueCondition.signal();
                        continue;
                    }
                    finally {
                        this.queueLock.unlock();
                        continue;
                    }
                }
                finally {
                    this.queueLock.lock();
                    try {
                        this.queue.remove(job);
                        continue;
                    }
                    finally {
                        this.queueLock.unlock();
                        continue;
                    }
                }
                break;
            }
        }
    }

    private static class QueueRunner
    implements Runnable {
        private final ServiceLocator locator;
        private final AsyncRunLevelContext asyncContext;
        private final ReentrantLock queueLock;
        private final List<ServiceHandle<?>> queue;
        private final UpOneLevel parent;
        private final ReentrantLock parentLock;
        private final int maxThreads;
        private ServiceHandle<?> wouldHaveBlocked;
        private final HashSet<ActiveDescriptor<?>> alreadyTried = new HashSet();

        private QueueRunner(ServiceLocator locator, AsyncRunLevelContext asyncContext, ReentrantLock queueLock, List<ServiceHandle<?>> queue, UpOneLevel parent, ReentrantLock parentLock, int maxThreads) {
            this.locator = locator;
            this.asyncContext = asyncContext;
            this.queueLock = queueLock;
            this.queue = queue;
            this.parent = parent;
            this.parentLock = parentLock;
            this.maxThreads = maxThreads;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServiceHandle<?> runningHandle = null;
            while (true) {
                ServiceHandle<?> job;
                boolean block;
                this.queueLock.lock();
                try {
                    if (runningHandle != null) {
                        this.parent.jobFinished(runningHandle);
                    }
                    if (this.wouldHaveBlocked != null) {
                        this.alreadyTried.add(this.wouldHaveBlocked.getActiveDescriptor());
                        this.queue.add(this.queue.size(), this.wouldHaveBlocked);
                        this.wouldHaveBlocked = null;
                    }
                    if (this.queue.isEmpty()) {
                        return;
                    }
                    if (this.maxThreads <= 0) {
                        block = true;
                    } else {
                        int currentlyEmptyThreads = this.maxThreads - this.parent.getJobsRunning();
                        boolean bl = block = this.queue.size() <= currentlyEmptyThreads;
                    }
                    if (block) {
                        job = this.queue.remove(0);
                    } else {
                        job = null;
                        for (int lcv = 0; lcv < this.queue.size(); ++lcv) {
                            ActiveDescriptor<?> candidate = this.queue.get(lcv).getActiveDescriptor();
                            if (this.alreadyTried.contains(candidate)) continue;
                            job = this.queue.remove(lcv);
                            break;
                        }
                        if (job == null) {
                            job = this.queue.remove(0);
                            block = true;
                        }
                    }
                    this.parent.jobRunning(job);
                    runningHandle = job;
                }
                finally {
                    this.queueLock.unlock();
                }
                this.oneJob(job, block);
            }
        }

        private boolean isWouldBlockRightNow(HashSet<ActiveDescriptor<?>> cycleChecker, ActiveDescriptor<?> checkMe) {
            if (checkMe == null) {
                return false;
            }
            if (cycleChecker.contains(checkMe)) {
                return false;
            }
            cycleChecker.add(checkMe);
            if (this.asyncContext.wouldBlockRightNow(checkMe)) {
                return true;
            }
            if (!checkMe.isReified()) {
                checkMe = this.locator.reifyDescriptor(checkMe);
            }
            for (Injectee ip : checkMe.getInjectees()) {
                ActiveDescriptor<?> childService;
                try {
                    childService = this.locator.getInjecteeDescriptor(ip);
                }
                catch (MultiException me) {
                    continue;
                }
                if (childService == null || !childService.getScope().equals(RunLevel.class.getName()) || !this.isWouldBlockRightNow(cycleChecker, childService)) continue;
                if (this.asyncContext.wouldBlockRightNow(checkMe)) {
                    return true;
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void oneJob(ServiceHandle<?> fService, boolean block) {
            fService.setServiceData(!block);
            boolean completed = true;
            try {
                boolean ok;
                this.parentLock.lock();
                try {
                    ok = !this.parent.cancelled && this.parent.accumulatedExceptions == null;
                }
                finally {
                    this.parentLock.unlock();
                }
                if (!block && this.isWouldBlockRightNow(new HashSet(), fService.getActiveDescriptor())) {
                    this.wouldHaveBlocked = fService;
                    completed = false;
                    ok = false;
                }
                if (ok) {
                    fService.getService();
                }
            }
            catch (MultiException me) {
                if (!block && CurrentTaskFuture.isWouldBlock(me)) {
                    this.wouldHaveBlocked = fService;
                    completed = false;
                } else if (!CurrentTaskFuture.isWasCancelled(me)) {
                    this.parent.fail(me, fService.getActiveDescriptor());
                }
            }
            catch (Throwable th) {
                this.parent.fail(th, fService.getActiveDescriptor());
            }
            finally {
                fService.setServiceData(null);
                if (completed) {
                    this.parent.jobComplete();
                }
            }
        }
    }

    private static class HardCancelDownTimer
    extends TimerTask {
        private final DownAllTheWay parent;
        private final List<ActiveDescriptor<?>> queue;
        private final ReentrantLock localQueueLock;
        private final Condition localQueueCondition;
        private int lastQueueSize;

        private HardCancelDownTimer(DownAllTheWay parent, List<ActiveDescriptor<?>> queue, ReentrantLock localQueueLock, Condition localQueueCondition) {
            this.parent = parent;
            this.queue = queue;
            this.localQueueLock = localQueueLock;
            this.localQueueCondition = localQueueCondition;
            this.lastQueueSize = queue.size();
        }

        @Override
        public void run() {
            this.localQueueLock.lock();
            try {
                int currentSize = this.queue.size();
                if (currentSize == 0) {
                    return;
                }
                if (currentSize == this.lastQueueSize) {
                    this.parent.downHardCancelled = true;
                    this.localQueueCondition.signal();
                } else {
                    this.lastQueueSize = currentSize;
                }
            }
            finally {
                this.localQueueLock.unlock();
            }
        }
    }

    private static class CancelTimer
    extends TimerTask {
        private final UpOneLevel parent;

        private CancelTimer(UpOneLevel parent) {
            this.parent = parent;
        }

        @Override
        public void run() {
            this.parent.hardCancel();
        }
    }

    private class UpOneLevel
    implements Runnable {
        private final ReentrantLock lock = new ReentrantLock();
        private final ReentrantLock queueLock = new ReentrantLock();
        private final int upToThisLevel;
        private final CurrentTaskFuture currentTaskFuture;
        private final List<ServiceHandle<RunLevelListener>> listeners;
        private final List<ServiceHandle<Sorter>> sorters;
        private final UpAllTheWay master;
        private final int maxThreads;
        private final long cancelTimeout;
        private int numJobs;
        private int completedJobs;
        private MultiException accumulatedExceptions;
        private boolean cancelled = false;
        private CancelTimer hardCanceller;
        private int numJobsRunning = 0;
        private boolean hardCancelled = false;
        private final HashSet<ServiceHandle<?>> outstandingHandles = new HashSet();

        private UpOneLevel(int paramUpToThisLevel, UpAllTheWay master, CurrentTaskFuture currentTaskFuture2, List<ServiceHandle<RunLevelListener>> listeners, List<ServiceHandle<Sorter>> sorters, int maxThreads, long cancelTimeout) {
            this.upToThisLevel = paramUpToThisLevel;
            this.master = master;
            this.maxThreads = maxThreads;
            this.currentTaskFuture = currentTaskFuture2;
            this.listeners = listeners;
            this.sorters = sorters;
            this.cancelTimeout = cancelTimeout;
        }

        private void cancel() {
            this.lock.lock();
            try {
                this.cancelled = true;
                this.hardCanceller = new CancelTimer(this);
                CurrentTaskFuture.this.timer.schedule((TimerTask)this.hardCanceller, this.cancelTimeout);
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void hardCancel() {
            CurrentTaskFuture.this.asyncContext.lock.lock();
            try {
                HashSet poisonMe;
                this.lock.lock();
                try {
                    this.hardCancelled = true;
                }
                finally {
                    this.lock.unlock();
                }
                this.queueLock.lock();
                try {
                    poisonMe = new HashSet(this.outstandingHandles);
                    this.outstandingHandles.clear();
                }
                finally {
                    this.queueLock.unlock();
                }
                for (ServiceHandle<?> handle : poisonMe) {
                    CurrentTaskFuture.this.asyncContext.hardCancelOne(handle.getActiveDescriptor());
                }
            }
            finally {
                CurrentTaskFuture.this.asyncContext.lock.unlock();
            }
            this.master.currentJobComplete(null);
        }

        private void jobRunning(ServiceHandle<?> handle) {
            ++this.numJobsRunning;
            this.outstandingHandles.add(handle);
        }

        private void jobFinished(ServiceHandle<?> handle) {
            this.outstandingHandles.remove(handle);
            --this.numJobsRunning;
        }

        private int getJobsRunning() {
            return this.numJobsRunning;
        }

        private List<ServiceHandle<?>> applySorters(List<ServiceHandle<?>> jobs) {
            List<ServiceHandle<?>> retVal = jobs;
            for (ServiceHandle<Sorter> sorterHandle : this.sorters) {
                List<ServiceHandle<?>> sortedList;
                Sorter sorter = sorterHandle.getService();
                if (sorter == null || (sortedList = sorter.sort(retVal)) == null) continue;
                retVal = sortedList;
            }
            return retVal;
        }

        @Override
        public void run() {
            ReentrantLock jobsLock = new ReentrantLock();
            List<ServiceHandle<?>> jobs = CurrentTaskFuture.this.locator.getAllServiceHandles(new IndexedFilter(){

                @Override
                public boolean matches(Descriptor d) {
                    return UpOneLevel.this.upToThisLevel == Utilities.getRunLevelValue(CurrentTaskFuture.this.locator, d);
                }

                @Override
                public String getAdvertisedContract() {
                    return RunLevel.class.getName();
                }

                @Override
                public String getName() {
                    return null;
                }
            });
            jobs = this.applySorters(jobs);
            this.numJobs = jobs.size();
            if (this.numJobs <= 0) {
                this.jobComplete();
                return;
            }
            int runnersToCreate = (this.numJobs < this.maxThreads ? this.numJobs : this.maxThreads) - 1;
            if (!CurrentTaskFuture.this.useThreads) {
                runnersToCreate = 0;
            }
            for (int lcv = 0; lcv < runnersToCreate; ++lcv) {
                QueueRunner runner = new QueueRunner(CurrentTaskFuture.this.locator, CurrentTaskFuture.this.asyncContext, jobsLock, jobs, this, this.lock, this.maxThreads);
                CurrentTaskFuture.this.executor.execute(runner);
            }
            QueueRunner myRunner = new QueueRunner(CurrentTaskFuture.this.locator, CurrentTaskFuture.this.asyncContext, jobsLock, jobs, this, this.lock, this.maxThreads);
            myRunner.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fail(Throwable th, Descriptor descriptor) {
            this.lock.lock();
            try {
                if (this.hardCancelled) {
                    return;
                }
                ErrorInformation info = CurrentTaskFuture.invokeOnError(this.currentTaskFuture, th, ErrorInformation.ErrorAction.GO_TO_NEXT_LOWER_LEVEL_AND_STOP, this.listeners, descriptor);
                if (ErrorInformation.ErrorAction.IGNORE.equals((Object)info.getAction())) {
                    return;
                }
                if (this.accumulatedExceptions == null) {
                    this.accumulatedExceptions = new MultiException();
                }
                this.accumulatedExceptions.addError(th);
            }
            finally {
                this.lock.unlock();
            }
        }

        private void jobComplete() {
            boolean complete = false;
            this.lock.lock();
            try {
                if (this.hardCancelled) {
                    return;
                }
                ++this.completedJobs;
                if (this.completedJobs >= this.numJobs) {
                    complete = true;
                    if (this.hardCanceller != null) {
                        this.hardCanceller.cancel();
                        this.hardCanceller = null;
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
            if (complete) {
                this.master.currentJobComplete(this.accumulatedExceptions);
            }
        }
    }
}

