/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.operation;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.extras.operation.internal.OperationHandleImpl;
import org.glassfish.hk2.extras.operation.internal.SingleOperationManager;
import org.glassfish.hk2.utilities.reflection.Logger;
import org.jvnet.hk2.annotations.Contract;

@Contract
public abstract class OperationContext<T extends Annotation>
implements Context<T> {
    private SingleOperationManager<T> manager;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final HashMap<OperationHandleImpl<T>, LinkedHashMap<ActiveDescriptor<?>, Object>> operationMap = new HashMap();
    private final HashSet<ActiveDescriptor<?>> creating = new HashSet();
    private final HashMap<Long, LinkedList<OperationHandleImpl<T>>> closingOperations = new HashMap();
    private boolean shuttingDown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <U> U findOrCreate(ActiveDescriptor<U> activeDescriptor, ServiceHandle<?> root) {
        Object retVal;
        LinkedHashMap<ActiveDescriptor<Object>, Object> serviceMap;
        boolean closingOperation;
        LinkedList<OperationHandleImpl<T>> closingOperationStack;
        SingleOperationManager<T> localManager;
        this.lock.lock();
        try {
            localManager = this.manager;
            closingOperationStack = this.closingOperations.get(Thread.currentThread().getId());
            closingOperation = closingOperationStack != null && !closingOperationStack.isEmpty();
        }
        finally {
            this.lock.unlock();
        }
        if (localManager == null) {
            throw new IllegalStateException("There is no manager for " + this.getScope().getName() + " on thread " + Thread.currentThread().getId());
        }
        OperationHandleImpl<T> operation = localManager.getCurrentOperationOnThisThread();
        if (operation == null) {
            this.lock.lock();
            try {
                if (!closingOperation) {
                    throw new IllegalStateException("There is no current operation of type " + this.getScope().getName() + " on thread " + Thread.currentThread().getId());
                }
                operation = closingOperationStack.get(0);
            }
            finally {
                this.lock.unlock();
            }
        }
        this.lock.lock();
        try {
            serviceMap = this.operationMap.get(operation);
            if (serviceMap == null) {
                if (closingOperation || this.shuttingDown) {
                    throw new IllegalStateException("The operation " + operation.getIdentifier() + " is closing.  A new instance of " + activeDescriptor + " cannot be created");
                }
                serviceMap = new LinkedHashMap();
                this.operationMap.put(operation, serviceMap);
            }
            if ((retVal = serviceMap.get(activeDescriptor)) != null) {
                Object object = retVal;
                return (U)object;
            }
            if (this.supportsNullCreation() && serviceMap.containsKey(activeDescriptor)) {
                U u = null;
                return u;
            }
            if (closingOperation || this.shuttingDown) {
                throw new IllegalStateException("The operation " + operation.getIdentifier() + " is closing.  A new instance of " + activeDescriptor + " cannot be created after searching existing descriptors");
            }
            while (this.creating.contains(activeDescriptor)) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            retVal = serviceMap.get(activeDescriptor);
            if (retVal != null) {
                Object e = retVal;
                return (U)e;
            }
            if (this.supportsNullCreation() && serviceMap.containsKey(activeDescriptor)) {
                U e = null;
                return e;
            }
            this.creating.add(activeDescriptor);
        }
        finally {
            this.lock.unlock();
        }
        retVal = null;
        boolean success = false;
        try {
            retVal = activeDescriptor.create(root);
            if (retVal == null && !this.supportsNullCreation()) {
                throw new IllegalArgumentException("The operation for context " + this.getScope().getName() + " does not support null creation, but descriptor " + activeDescriptor + " returned null");
            }
            success = true;
        }
        finally {
            this.lock.lock();
            try {
                if (success) {
                    serviceMap.put(activeDescriptor, retVal);
                }
                this.creating.remove(activeDescriptor);
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
        return (U)retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(ActiveDescriptor<?> descriptor) {
        SingleOperationManager<T> localManager;
        this.lock.lock();
        try {
            localManager = this.manager;
        }
        finally {
            this.lock.unlock();
        }
        if (localManager == null) {
            return false;
        }
        OperationHandleImpl<T> operation = localManager.getCurrentOperationOnThisThread();
        if (operation == null) {
            return false;
        }
        this.lock.lock();
        try {
            HashMap serviceMap = this.operationMap.get(operation);
            if (serviceMap == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = serviceMap.containsKey(descriptor);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyOne(ActiveDescriptor<?> descriptor) {
        this.lock.lock();
        try {
            for (HashMap hashMap : this.operationMap.values()) {
                Object killMe = hashMap.remove(descriptor);
                if (killMe == null) continue;
                descriptor.dispose(killMe);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOperation(OperationHandleImpl<T> operation) {
        HashMap serviceMap;
        LinkedList<OperationHandleImpl<Object>> stack;
        long tid = Thread.currentThread().getId();
        this.lock.lock();
        try {
            stack = this.closingOperations.get(tid);
            if (stack == null) {
                stack = new LinkedList();
                this.closingOperations.put(tid, stack);
            }
            stack.addFirst(operation);
            serviceMap = this.operationMap.get(operation);
        }
        finally {
            this.lock.unlock();
        }
        try {
            if (serviceMap == null) {
                return;
            }
            LinkedList destructionList = new LinkedList();
            for (Map.Entry entry : serviceMap.entrySet()) {
                destructionList.addFirst(entry);
            }
            for (Map.Entry entry : destructionList) {
                ActiveDescriptor desc = (ActiveDescriptor)entry.getKey();
                Object value = entry.getValue();
                try {
                    desc.dispose(value);
                }
                catch (Throwable th) {
                    Logger.getLogger().debug(this.getClass().getName(), "closeOperation", th);
                }
            }
        }
        finally {
            this.lock.lock();
            try {
                this.operationMap.remove(operation);
                stack.removeFirst();
                if (stack.isEmpty()) {
                    this.closingOperations.remove(tid);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Set<OperationHandleImpl<T>> toShutDown;
        this.lock.lock();
        try {
            this.shuttingDown = true;
            toShutDown = this.operationMap.keySet();
        }
        finally {
            this.lock.unlock();
        }
        try {
            for (OperationHandleImpl<T> shutDown : toShutDown) {
                shutDown.closeOperation();
            }
        }
        finally {
            this.lock.lock();
            try {
                this.operationMap.clear();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public boolean supportsNullCreation() {
        return false;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public void setOperationManager(SingleOperationManager<T> manager) {
        this.lock.lock();
        try {
            this.manager = manager;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "OperationContext(" + this.getScope().getName() + "," + System.identityHashCode(this) + ")";
    }
}

