/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.hk2bridge.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;

public class CrossOverDescriptor<T>
extends AbstractActiveDescriptor<T> {
    private final ReentrantLock lock = new ReentrantLock();
    private final ServiceLocator remoteLocator;
    private final ActiveDescriptor<T> remote;
    private boolean remoteReified;

    public CrossOverDescriptor(ServiceLocator local, ActiveDescriptor<T> localService) {
        super(localService);
        this.remoteLocator = local;
        this.remote = localService;
        this.remoteReified = localService.isReified();
        if (this.remoteReified) {
            this.setScopeAsAnnotation(this.remote.getScopeAsAnnotation());
        } else {
            this.setScope(this.remote.getScope());
        }
        this.addMetadata("org.jvnet.hk2.hk2bridge.locator.id", Long.toString(local.getLocatorId()));
        this.addMetadata("org.jvnet.hk2.hk2bridge.service.id", Long.toString(localService.getServiceId()));
    }

    @Override
    public boolean isReified() {
        return true;
    }

    private void checkState() {
        this.lock.lock();
        try {
            if (this.remoteReified) {
                return;
            }
            this.remoteReified = true;
            if (this.remote.isReified()) {
                return;
            }
            this.remoteLocator.reifyDescriptor(this.remote);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Class<?> getImplementationClass() {
        this.checkState();
        return this.remote.getImplementationClass();
    }

    @Override
    public Type getImplementationType() {
        this.checkState();
        return this.remote.getImplementationType();
    }

    @Override
    public void setImplementationType(Type t) {
        this.checkState();
        throw new AssertionError((Object)"Can not set type of remove descriptor");
    }

    @Override
    public Set<Type> getContractTypes() {
        this.checkState();
        return this.remote.getContractTypes();
    }

    @Override
    public Annotation getScopeAsAnnotation() {
        this.checkState();
        return this.remote.getScopeAsAnnotation();
    }

    @Override
    public Class<? extends Annotation> getScopeAnnotation() {
        this.checkState();
        return this.remote.getScopeAnnotation();
    }

    @Override
    public Set<Annotation> getQualifierAnnotations() {
        this.checkState();
        return this.remote.getQualifierAnnotations();
    }

    @Override
    public List<Injectee> getInjectees() {
        this.checkState();
        return this.remote.getInjectees();
    }

    @Override
    public Long getFactoryServiceId() {
        this.checkState();
        return this.remote.getFactoryServiceId();
    }

    @Override
    public Long getFactoryLocatorId() {
        this.checkState();
        return this.remote.getFactoryLocatorId();
    }

    @Override
    public T create(ServiceHandle<?> root) {
        this.checkState();
        return this.remoteLocator.getService(this.remote, root);
    }

    @Override
    public void dispose(T instance) {
        this.checkState();
        this.remote.dispose(instance);
    }
}

