/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.io.OutputStream;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.grizzly.websockets.FrameType;
import org.glassfish.grizzly.websockets.Utf8Utils;
import org.glassfish.grizzly.websockets.Utils;
import org.glassfish.grizzly.websockets.WebSocket;

public class DataFrame {
    private String payload;
    private byte[] bytes;
    private final FrameType type;
    private boolean last = true;

    public static boolean isDataFrame(Object o) {
        return o instanceof DataFrame;
    }

    public DataFrame(FrameType type2) {
        this.type = type2;
    }

    public DataFrame(FrameType type2, String data) {
        this(type2, data, true);
    }

    public DataFrame(FrameType type2, String data, boolean fin) {
        this.type = type2;
        this.setPayload(data);
        this.last = fin;
    }

    public DataFrame(FrameType type2, byte[] data) {
        this(type2, data, true);
    }

    public DataFrame(FrameType type2, byte[] data, boolean fin) {
        this.type = type2;
        type2.setPayload(this, data);
        this.last = fin;
    }

    public FrameType getType() {
        return this.type;
    }

    public String getTextPayload() {
        return this.payload;
    }

    public final void setPayload(String payload) {
        this.payload = payload;
    }

    public void setPayload(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        if (this.payload != null) {
            this.bytes = Utf8Utils.encode(Charsets.UTF8_CHARSET, this.payload);
        }
        return this.bytes;
    }

    public void toStream(OutputStream os) throws IOException {
        if (this.payload != null) {
            Utf8Utils.encode(Charsets.UTF8_CHARSET, this.payload, os);
        }
    }

    public void respond(WebSocket socket) {
        this.getType().respond(socket, this);
    }

    public String toString() {
        return "DataFrame" + "{" + "last=" + this.last + ", type=" + this.type.getClass().getSimpleName() + ", payload='" + this.getTextPayload() + '\'' + ", bytes=" + Utils.toString(this.bytes) + '}';
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }
}

