/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.client;

import com.sun.enterprise.universal.io.SmartFile;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.flashlight.FlashlightLoggerInfo;

final class AgentAttacherInternal {
    private static final Logger LOG = FlashlightLoggerInfo.getLogger();
    private static boolean isAttached;

    AgentAttacherInternal() {
    }

    static boolean isAttached() {
        return isAttached;
    }

    static boolean attachAgent() {
        return AgentAttacherInternal.attachAgent(-1L, "");
    }

    static boolean attachAgent(long pid, String options) {
        try {
            if (isAttached) {
                return true;
            }
            if (pid < 0L) {
                pid = ProcessHandle.current().pid();
            }
            if (pid < 0L) {
                LOG.log(Level.WARNING, "NCLS-MON-00501");
                return false;
            }
            VirtualMachine vm = VirtualMachine.attach(String.valueOf(pid));
            String ir = System.getProperty(GlassFishVariable.INSTALL_ROOT.getSystemPropertyName());
            File dir = new File(ir, "lib" + File.separator + "monitor");
            if (!dir.isDirectory()) {
                LOG.log(Level.WARNING, "NCLS-MON-00503", dir);
                return false;
            }
            File agentJar = new File(dir, "flashlight-agent.jar");
            if (!agentJar.isFile()) {
                LOG.log(Level.WARNING, "NCLS-MON-00502", dir);
                return false;
            }
            vm.loadAgent(SmartFile.sanitize(agentJar.getPath()), options);
            isAttached = true;
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "NCLS-MON-00504", t.getMessage());
            isAttached = false;
        }
        return isAttached;
    }
}

