/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.extras.grizzly;

import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.logging.Level;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.grizzly.http.server.HttpHandler;

public class GrizzlyApp
implements ApplicationContainer {
    final ClassLoader cl;
    final Collection<Adapter> modules;
    final RequestDispatcher dispatcher;

    public GrizzlyApp(Collection<Adapter> adapters, RequestDispatcher dispatcher, ClassLoader cl) {
        this.modules = adapters;
        this.dispatcher = dispatcher;
        this.cl = cl;
    }

    public Object getDescriptor() {
        return null;
    }

    @Override
    public boolean start(ApplicationContext startupContext) throws Exception {
        for (Adapter module : this.modules) {
            this.dispatcher.registerEndpoint(module.contextRoot, module.service, this);
        }
        return true;
    }

    @Override
    public boolean stop(ApplicationContext stopContext) {
        boolean success = true;
        for (Adapter module : this.modules) {
            try {
                this.dispatcher.unregisterEndpoint(module.contextRoot);
            }
            catch (EndpointRegistrationException e) {
                LogDomains.getLogger(this.getClass(), "jakarta.enterprise.system.tools.deployment").log(Level.SEVERE, "Exception while unregistering adapter at " + module.contextRoot, e);
                success = false;
            }
        }
        return success;
    }

    @Override
    public boolean suspend() {
        return false;
    }

    @Override
    public boolean resume() throws Exception {
        return false;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public static final class Adapter {
        final HttpHandler service;
        final String contextRoot;

        public Adapter(String contextRoot, HttpHandler adapter) {
            this.service = adapter;
            this.contextRoot = contextRoot;
        }
    }
}

