/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.expressly.parser;

import jakarta.el.ELClass;
import jakarta.el.ELException;
import jakarta.el.FunctionMapper;
import jakarta.el.LambdaExpression;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.glassfish.expressly.lang.EvaluationContext;
import org.glassfish.expressly.parser.AstMethodArguments;
import org.glassfish.expressly.parser.ELParserTreeConstants;
import org.glassfish.expressly.parser.SimpleNode;
import org.glassfish.expressly.util.MessageFactory;

public final class AstFunction
extends SimpleNode {
    protected String localName = "";
    protected String prefix = "";

    public AstFunction(int id) {
        super(id);
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getOutputName() {
        if (this.prefix.length() == 0) {
            return this.localName;
        }
        return this.prefix + ":" + this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Class<?> getType(EvaluationContext ctx) throws ELException {
        FunctionMapper functionMapper = ctx.getFunctionMapper();
        if (functionMapper == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.null"));
        }
        Method functionMethod = functionMapper.resolveFunction(this.prefix, this.localName);
        if (functionMethod == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.method", this.getOutputName()));
        }
        return functionMethod.getReturnType();
    }

    private Object findValue(EvaluationContext ctx, String name) {
        ValueExpression expr;
        if (ctx.isLambdaArgument(name)) {
            return ctx.getLambdaArgument(name);
        }
        VariableMapper varMapper = ctx.getVariableMapper();
        if (varMapper != null && (expr = varMapper.resolveVariable(name)) != null) {
            return expr.getValue(ctx.getELContext());
        }
        ctx.setPropertyResolved(false);
        Object ret = ctx.getELResolver().getValue(ctx, null, name);
        if (ctx.isPropertyResolved()) {
            return ret;
        }
        return null;
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        Object val;
        if (this.prefix.length() == 0 && (val = this.findValue(ctx, this.localName)) != null && val instanceof LambdaExpression) {
            for (int i = 0; i < this.children.length; ++i) {
                Object[] params = ((AstMethodArguments)this.children[i]).getParameters(ctx);
                if (!(val instanceof LambdaExpression)) {
                    throw new ELException(MessageFactory.get("error.function.syntax", this.getOutputName()));
                }
                val = ((LambdaExpression)val).invoke(ctx, params);
            }
            return val;
        }
        FunctionMapper functionMapper = ctx.getFunctionMapper();
        Method functionMethod = null;
        if (functionMapper != null) {
            functionMethod = functionMapper.resolveFunction(this.prefix, this.localName);
        }
        if (functionMethod == null) {
            if (this.prefix.length() == 0 && ctx.getImportHandler() != null) {
                Class<?> resolvedClass = ctx.getImportHandler().resolveClass(this.localName);
                String methodName = null;
                if (resolvedClass != null) {
                    methodName = "<init>";
                } else {
                    resolvedClass = ctx.getImportHandler().resolveStatic(this.localName);
                    methodName = this.localName;
                }
                if (resolvedClass != null) {
                    Object[] params = ((AstMethodArguments)this.children[0]).getParameters(ctx);
                    return ctx.getELResolver().invoke(ctx, new ELClass(resolvedClass), methodName, null, params);
                }
            }
            if (functionMapper == null) {
                throw new ELException(MessageFactory.get("error.fnMapper.null"));
            }
            throw new ELException(MessageFactory.get("error.fnMapper.method", this.getOutputName()));
        }
        Class<?>[] paramTypes = functionMethod.getParameterTypes();
        Object[] params = ((AstMethodArguments)this.children[0]).getParameters(ctx);
        Object result = null;
        for (int i = 0; i < params.length; ++i) {
            try {
                params[i] = ctx.convertToType(params[i], paramTypes[i]);
                continue;
            }
            catch (ELException ele) {
                throw new ELException(MessageFactory.get("error.function", this.getOutputName()), ele);
            }
        }
        try {
            result = functionMethod.invoke(null, params);
        }
        catch (IllegalAccessException iae) {
            throw new ELException(MessageFactory.get("error.function", this.getOutputName()), iae);
        }
        catch (InvocationTargetException ite) {
            throw new ELException(MessageFactory.get("error.function", this.getOutputName()), ite.getCause());
        }
        return result;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String toString() {
        return ELParserTreeConstants.jjtNodeName[this.id] + "[" + this.getOutputName() + "]";
    }
}

