/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.expressly;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.MethodExpression;
import jakarta.el.MethodInfo;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.glassfish.expressly.util.ReflectionUtil;

public class MethodExpressionLiteral
extends MethodExpression
implements Externalizable {
    private Class<?> expectedType;
    private String expression;
    private Class<?>[] paramTypes;

    public MethodExpressionLiteral() {
    }

    public MethodExpressionLiteral(String expression, Class<?> expectedType, Class<?>[] paramTypes) {
        this.expression = expression;
        this.expectedType = expectedType;
        this.paramTypes = paramTypes;
    }

    @Override
    public MethodInfo getMethodInfo(ELContext context) throws ELException {
        return new MethodInfo(this.expression, this.expectedType, this.paramTypes);
    }

    @Override
    public Object invoke(ELContext context, Object[] params) throws ELException {
        if (this.expectedType == null) {
            return this.expression;
        }
        try {
            return context.convertToType(this.expression, this.expectedType);
        }
        catch (Exception ex) {
            throw new ELException(ex);
        }
    }

    @Override
    public String getExpressionString() {
        return this.expression;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof MethodExpressionLiteral && this.hashCode() == obj.hashCode();
    }

    @Override
    public int hashCode() {
        return this.expression.hashCode();
    }

    @Override
    public boolean isLiteralText() {
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.expression = in.readUTF();
        String type2 = in.readUTF();
        if (!"".equals(type2)) {
            this.expectedType = ReflectionUtil.forName(type2);
        }
        this.paramTypes = ReflectionUtil.toTypeArray((String[])in.readObject());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.expression);
        out.writeUTF(this.expectedType != null ? this.expectedType.getName() : "");
        out.writeObject(ReflectionUtil.toTypeNameArray(this.paramTypes));
    }
}

