/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.constraints.transformer;

import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebUserDataPermission;
import jakarta.servlet.annotation.ServletSecurity;
import java.security.Permission;
import java.security.Permissions;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.glassfish.exousia.constraints.SecurityConstraint;
import org.glassfish.exousia.constraints.WebResourceCollection;
import org.glassfish.exousia.constraints.transformer.ConstraintValue;
import org.glassfish.exousia.constraints.transformer.MethodValue;
import org.glassfish.exousia.constraints.transformer.PatternBuilder;
import org.glassfish.exousia.permissions.JakartaPermissions;

public class ConstraintsToPermissionsTransformer {
    private static final System.Logger LOG = System.getLogger(ConstraintsToPermissionsTransformer.class.getName());
    static final String CLASS_NAME = ConstraintsToPermissionsTransformer.class.getSimpleName();
    private static final int DEFAULT_MAPPING = 0;
    private static final int EXTENSION_MAPPING = 1;
    private static final int PREFIX_MAPPING = 2;
    private static final int EXACT_MAPPING = 3;

    private ConstraintsToPermissionsTransformer() {
    }

    public static JakartaPermissions createResourceAndDataPermissions(Set<String> declaredRoles, boolean isDenyUncoveredHttpMethods, List<SecurityConstraint> securityConstraints) {
        LOG.log(System.Logger.Level.DEBUG, "Jakarta Authorization: constraint translation");
        Collection<PatternBuilder> patterns = ConstraintsToPermissionsTransformer.constraintsToIntermediatePatterns(declaredRoles, securityConstraints);
        JakartaPermissions jakartaPermissions = ConstraintsToPermissionsTransformer.intermediatePatternsToPermissions(patterns, isDenyUncoveredHttpMethods);
        if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
            ConstraintsToPermissionsTransformer.logPermissions(jakartaPermissions);
        }
        return jakartaPermissions;
    }

    private static Collection<PatternBuilder> constraintsToIntermediatePatterns(Set<String> declaredRoles, List<SecurityConstraint> securityConstraints) {
        LOG.log(System.Logger.Level.TRACE, "constraintsToIntermediatePatterns(declaredRoles={0}, securityConstraints={1})", declaredRoles, securityConstraints);
        HashMap<String, PatternBuilder> patternBuilderMap = new HashMap<String, PatternBuilder>();
        patternBuilderMap.put("/", new PatternBuilder("/"));
        for (SecurityConstraint securityConstraint : securityConstraints) {
            LOG.log(System.Logger.Level.TRACE, "Constraint translation: begin parsing security constraint");
            Set<String> constraintRolesAllowed = securityConstraint.getRolesAllowed();
            ServletSecurity.TransportGuarantee transportGuarantee = securityConstraint.getTransportGuarantee();
            for (WebResourceCollection webResourceCollection : securityConstraint.getWebResourceCollections()) {
                LOG.log(System.Logger.Level.TRACE, "Constraint translation: begin parsing web resource collection");
                for (String urlPattern : webResourceCollection.getUrlPatterns()) {
                    urlPattern = urlPattern.replaceAll(":", "%3A");
                    LOG.log(System.Logger.Level.DEBUG, "Constraint translation: process url pattern: {0}", urlPattern);
                    PatternBuilder patternBuilder = (PatternBuilder)patternBuilderMap.get(urlPattern);
                    if (patternBuilder == null) {
                        patternBuilder = new PatternBuilder(urlPattern);
                        for (Map.Entry patternBuilderEntry : patternBuilderMap.entrySet()) {
                            String otherUrl = (String)patternBuilderEntry.getKey();
                            int otherUrlType = ConstraintsToPermissionsTransformer.patternType(otherUrl);
                            switch (ConstraintsToPermissionsTransformer.patternType(urlPattern)) {
                                case 2: {
                                    if ((otherUrlType == 2 || otherUrlType == 3) && ConstraintsToPermissionsTransformer.implies(urlPattern, otherUrl)) {
                                        patternBuilder.addQualifier(otherUrl);
                                        break;
                                    }
                                    if (otherUrlType == 2 && ConstraintsToPermissionsTransformer.implies(otherUrl, urlPattern)) {
                                        ((PatternBuilder)patternBuilderEntry.getValue()).addQualifier(urlPattern);
                                        break;
                                    }
                                    if (otherUrlType != 1 && otherUrlType != 0) break;
                                    ((PatternBuilder)patternBuilderEntry.getValue()).addQualifier(urlPattern);
                                    break;
                                }
                                case 1: {
                                    if (otherUrlType == 2 || otherUrlType == 3 && ConstraintsToPermissionsTransformer.implies(urlPattern, otherUrl)) {
                                        patternBuilder.addQualifier(otherUrl);
                                        break;
                                    }
                                    if (otherUrlType != 0) break;
                                    ((PatternBuilder)patternBuilderEntry.getValue()).addQualifier(urlPattern);
                                    break;
                                }
                                case 0: {
                                    if (otherUrlType == 0) break;
                                    patternBuilder.addQualifier(otherUrl);
                                    break;
                                }
                                case 3: {
                                    if ((otherUrlType == 2 || otherUrlType == 1) && ConstraintsToPermissionsTransformer.implies(otherUrl, urlPattern)) {
                                        ((PatternBuilder)patternBuilderEntry.getValue()).addQualifier(urlPattern);
                                        break;
                                    }
                                    if (otherUrlType != 0) break;
                                    ((PatternBuilder)patternBuilderEntry.getValue()).addQualifier(urlPattern);
                                    break;
                                }
                            }
                        }
                        patternBuilderMap.put(urlPattern, patternBuilder);
                    }
                    BitSet methods = MethodValue.encodeMethodsToBits(webResourceCollection.getHttpMethods());
                    BitSet omittedMethods = null;
                    if (methods.isEmpty()) {
                        omittedMethods = MethodValue.encodeMethodsToBits(webResourceCollection.getHttpMethodOmissions());
                    }
                    patternBuilder.setMethodOutcomes(declaredRoles, constraintRolesAllowed, transportGuarantee, methods, omittedMethods);
                    LOG.log(System.Logger.Level.TRACE, "Constraint translation: end processing url pattern: {0}", urlPattern);
                }
            }
        }
        return patternBuilderMap.values();
    }

    private static JakartaPermissions intermediatePatternsToPermissions(Collection<PatternBuilder> patterns, boolean isDenyUncoveredHttpMethods) {
        LOG.log(System.Logger.Level.DEBUG, "Constraint capture: begin processing qualified url patterns - uncovered http methods will be {0}", isDenyUncoveredHttpMethods ? "denied" : "permitted");
        JakartaPermissions jakartaPermissions = new JakartaPermissions();
        for (PatternBuilder patternBuilder : patterns) {
            if (patternBuilder.isIrrelevantByQualifier()) continue;
            String urlPatternSpec = patternBuilder.getUrlPatternSpec();
            LOG.log(System.Logger.Level.DEBUG, "Constraint capture: urlPattern: {0}", urlPatternSpec);
            patternBuilder.handleUncovered(isDenyUncoveredHttpMethods);
            ConstraintsToPermissionsTransformer.handleExcluded(jakartaPermissions.getExcluded(), patternBuilder, urlPatternSpec);
            ConstraintsToPermissionsTransformer.handlePerRole(jakartaPermissions.getPerRole(), patternBuilder, urlPatternSpec);
            ConstraintsToPermissionsTransformer.handleUnchecked(jakartaPermissions.getUnchecked(), patternBuilder, urlPatternSpec);
            ConstraintsToPermissionsTransformer.handleConnections(jakartaPermissions.getUnchecked(), patternBuilder, urlPatternSpec);
        }
        return jakartaPermissions;
    }

    private static void handleExcluded(Permissions collection, PatternBuilder patternBuilder, String name) {
        Object actions2 = null;
        BitSet excludedMethods = patternBuilder.getExcludedMethods();
        if (patternBuilder.getOtherConstraint().isExcluded()) {
            BitSet methods = patternBuilder.getMethodSet();
            methods.andNot(excludedMethods);
            if (!methods.isEmpty()) {
                actions2 = "!" + MethodValue.getActions(methods);
            }
        } else if (!excludedMethods.isEmpty()) {
            actions2 = MethodValue.getActions(excludedMethods);
        } else {
            return;
        }
        collection.add(new WebResourcePermission(name, (String)actions2));
        collection.add(new WebUserDataPermission(name, (String)actions2));
        LOG.log(System.Logger.Level.DEBUG, "Constraint capture: adding excluded methods: {0}", actions2);
    }

    private static void handlePerRole(Map<String, Permissions> map, PatternBuilder patternBuilder, String urlPatternSpec) {
        BitSet methods;
        HashMap<String, BitSet> roleMap = patternBuilder.getRoleMap();
        List<String> roleList = null;
        if (!patternBuilder.getOtherConstraint().isExcluded() && patternBuilder.getOtherConstraint().isAuthConstrained()) {
            roleList = patternBuilder.getOtherConstraint().getRoles();
            for (String roleName : roleList) {
                BitSet methods2 = patternBuilder.getMethodSet();
                BitSet roleMethods = (BitSet)roleMap.get(roleName);
                if (roleMethods != null) {
                    methods2.andNot(roleMethods);
                }
                String httpMethodSpec = null;
                if (!methods2.isEmpty()) {
                    httpMethodSpec = "!" + MethodValue.getActions(methods2);
                }
                ConstraintsToPermissionsTransformer.addToRoleMap(map, roleName, new WebResourcePermission(urlPatternSpec, httpMethodSpec));
            }
        }
        if (!(methods = patternBuilder.getMethodSet()).isEmpty()) {
            for (Map.Entry roleEntry : roleMap.entrySet()) {
                BitSet roleMethods;
                String roleName = (String)roleEntry.getKey();
                if (roleList != null && roleList.contains(roleName) || (roleMethods = (BitSet)roleEntry.getValue()).isEmpty()) continue;
                ConstraintsToPermissionsTransformer.addToRoleMap(map, roleName, new WebResourcePermission(urlPatternSpec, MethodValue.getActions(roleMethods)));
            }
        }
    }

    private static void handleUnchecked(Permissions collection, PatternBuilder patternBuilder, String urlPatternSpec) {
        Object httpMethodSpec = null;
        BitSet noAuthMethods = patternBuilder.getNoAuthMethods();
        if (!patternBuilder.getOtherConstraint().isAuthConstrained()) {
            BitSet methods = patternBuilder.getMethodSet();
            methods.andNot(noAuthMethods);
            if (!methods.isEmpty()) {
                httpMethodSpec = "!" + MethodValue.getActions(methods);
            }
        } else if (!noAuthMethods.isEmpty()) {
            httpMethodSpec = MethodValue.getActions(noAuthMethods);
        } else {
            return;
        }
        collection.add(new WebResourcePermission(urlPatternSpec, (String)httpMethodSpec));
        LOG.log(System.Logger.Level.DEBUG, "Constraint capture: adding unchecked (for authorization) methods: {0}", httpMethodSpec);
    }

    private static void handleConnections(Permissions permissions, PatternBuilder patternBuilder, String name) {
        BitSet allConnectMethods = null;
        boolean allConnectAtOther = patternBuilder.getOtherConstraint().isConnectAllowed(1);
        for (int i = 0; i < ConstraintValue.connectKeys.length; ++i) {
            Object actions2 = null;
            String transport = ConstraintValue.connectKeys[i];
            BitSet connectMethods = patternBuilder.getConnectMap(1 << i);
            if (i == 0) {
                allConnectMethods = connectMethods;
            } else {
                connectMethods.andNot(allConnectMethods);
            }
            if (patternBuilder.getOtherConstraint().isConnectAllowed(1 << i)) {
                if (i != 0 && allConnectAtOther) {
                    if (connectMethods.isEmpty()) continue;
                    actions2 = MethodValue.getActions(connectMethods);
                } else {
                    BitSet methods = patternBuilder.getMethodSet();
                    methods.andNot(connectMethods);
                    if (!methods.isEmpty()) {
                        actions2 = "!" + MethodValue.getActions(methods);
                    }
                }
            } else {
                if (connectMethods.isEmpty()) continue;
                actions2 = MethodValue.getActions(connectMethods);
            }
            actions2 = actions2 == null ? "" : actions2;
            String combinedActions = (String)actions2 + ":" + transport;
            permissions.add(new WebUserDataPermission(name, combinedActions));
            LOG.log(System.Logger.Level.DEBUG, "Constraint capture: adding methods that accept connections with protection: {0} methods: {1}", transport, actions2);
        }
    }

    static int patternType(Object urlPattern) {
        String pattern = urlPattern.toString();
        if (pattern.startsWith("*.")) {
            return 1;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            return 2;
        }
        if (pattern.equals("/")) {
            return 0;
        }
        return 3;
    }

    static boolean implies(String pattern, String path) {
        if (pattern.equals(path)) {
            return true;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            int length = (pattern = pattern.substring(0, pattern.length() - 2)).length();
            if (length == 0) {
                return true;
            }
            return path.startsWith(pattern) && (path.length() == length || path.substring(length).startsWith("/"));
        }
        if (pattern.startsWith("*.")) {
            int slash = path.lastIndexOf(47);
            int period = path.lastIndexOf(46);
            return slash >= 0 && period > slash && path.endsWith(pattern.substring(1));
        }
        return pattern.equals("/");
    }

    private static void addToRoleMap(Map<String, Permissions> roleMap, String roleName, Permission permission) {
        roleMap.computeIfAbsent(roleName, e -> new Permissions()).add(permission);
        LOG.log(System.Logger.Level.DEBUG, "Constraint capture: adding methods to role: {0} methods: {1}", roleName, permission.getActions());
    }

    private static void logPermissions(JakartaPermissions permissions) {
        StringBuilder message = new StringBuilder();
        message.append("Resolved permissions:");
        message.append("\n  Exclusions:");
        permissions.getExcluded().elementsAsStream().forEach(ConstraintsToPermissionsTransformer.toMessageElement(message));
        message.append("\n  Unchecked:");
        permissions.getUnchecked().elementsAsStream().forEach(ConstraintsToPermissionsTransformer.toMessageElement(message));
        message.append("\n  Checked:");
        for (Map.Entry<String, Permissions> roleEntry : permissions.getPerRole().entrySet()) {
            message.append("\n    Role ").append(roleEntry.getKey()).append(':');
            roleEntry.getValue().elementsAsStream().forEach(ConstraintsToPermissionsTransformer.toMessageElement(message));
        }
        LOG.log(System.Logger.Level.DEBUG, message);
    }

    private static Consumer<? super Permission> toMessageElement(StringBuilder message) {
        return permission -> message.append("\n    type: ").append(ConstraintsToPermissionsTransformer.permissionType(permission)).append(", name: ").append(permission.getName()).append(", actions: ").append(permission.getActions());
    }

    private static String permissionType(Permission permission) {
        return permission instanceof WebResourcePermission ? "WRP  " : "WUDP ";
    }
}

