/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.module.config;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.config.AuthConfig;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.epicyro.config.helper.AuthMessagePolicy;
import org.glassfish.epicyro.config.helper.ModuleConfigurationManager;
import org.glassfish.epicyro.data.AuthModuleBaseConfig;
import org.glassfish.epicyro.data.AuthModuleInstanceHolder;

public class GFAuthConfig
implements AuthConfig {
    protected Map<String, Object> properties;
    protected ModuleConfigurationManager moduleConfigurationManager;
    protected AuthConfigProvider authConfigProvider;
    protected String messageLayer;
    protected String appContext;
    protected CallbackHandler handler;
    protected String authModuleType;
    protected String authModuleId;
    protected boolean init;
    protected boolean onePolicy;
    protected MessagePolicy[] soapPolicies;
    protected AuthConfigFactory authConfigFactory;

    public GFAuthConfig(Map<String, Object> properties, ModuleConfigurationManager moduleConfigurationManager, AuthConfigProvider authConfigProvider, String messageLayer, String appContext, CallbackHandler handler, String authModuleType) {
        Provider provider;
        this.properties = properties;
        this.moduleConfigurationManager = moduleConfigurationManager;
        this.authConfigProvider = authConfigProvider;
        this.messageLayer = messageLayer;
        this.appContext = appContext;
        this.handler = handler != null ? handler : AuthMessagePolicy.getDefaultCallbackHandler();
        this.authModuleType = authModuleType;
        if (this.properties == null && (provider = Security.getProvider("EleosProvider")) != null) {
            this.properties = new HashMap<String, Object>();
            this.properties.put("authContextIdGenerator", provider.get("authContextIdGenerator"));
            this.properties.put("soapPolicyGenerator", provider.get("soapPolicyGenerator"));
        }
    }

    @Override
    public String getMessageLayer() {
        return this.messageLayer;
    }

    @Override
    public String getAppContext() {
        return this.appContext;
    }

    @Override
    public String getAuthContextID(MessageInfo messageInfo) {
        if (this.properties.containsKey("authContextIdGenerator")) {
            Function authContextIdGenerator = (Function)this.properties.get("authContextIdGenerator");
            return (String)authContextIdGenerator.apply(messageInfo);
        }
        if ("HttpServlet".equals(this.messageLayer)) {
            return Boolean.valueOf((String)messageInfo.getMap().get("jakarta.security.auth.message.MessagePolicy.isMandatory")).toString();
        }
        return null;
    }

    @Override
    public void refresh() {
        this.moduleConfigurationManager.loadParser(this.authConfigProvider, this.authConfigFactory, null);
    }

    @Override
    public boolean isProtected() {
        return true;
    }

    CallbackHandler getCallbackHandler() {
        return this.handler;
    }

    protected AuthModuleInstanceHolder getAuthModuleInstanceHolder(String authContextID, Map<String, Object> properties) throws AuthException {
        MessagePolicy[] policies;
        AuthModuleBaseConfig authModuleConfig;
        if (!this.init) {
            this.initialize(authContextID, properties);
        }
        if ((authModuleConfig = this.moduleConfigurationManager.getAuthModuleConfig(this.messageLayer, this.authModuleId, (policies = "HttpServlet".equals(this.messageLayer) ? AuthMessagePolicy.getHttpServletPolicies(authContextID) : this.soapPolicies)[0], policies[1], this.authModuleType)) == null) {
            return null;
        }
        return this.moduleConfigurationManager.createAuthModuleInstance(authModuleConfig, this.handler, this.authModuleType, properties);
    }

    private void initialize(String authContextID, Map<String, Object> properties) {
        if (!this.init) {
            this.authModuleId = (String)properties.get("authModuleId");
            if ("HttpServlet".equals(this.messageLayer)) {
                this.onePolicy = true;
            } else if (this.properties.containsKey("soapPolicyGenerator")) {
                BiFunction soapPolicyGenerator = (BiFunction)this.properties.get("soapPolicyGenerator");
                this.soapPolicies = (MessagePolicy[])soapPolicyGenerator.apply(authContextID, properties);
            }
            this.init = true;
        }
    }
}

