/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.helper;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.module.ClientAuthModule;
import jakarta.security.auth.message.module.ServerAuthModule;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.epicyro.config.factory.ConfigParser;
import org.glassfish.epicyro.config.helper.ObjectUtils;
import org.glassfish.epicyro.config.helper.OperationLock;
import org.glassfish.epicyro.data.AuthModuleBaseConfig;
import org.glassfish.epicyro.data.AuthModuleConfig;
import org.glassfish.epicyro.data.AuthModuleInstanceHolder;
import org.glassfish.epicyro.data.AuthModulesLayerConfig;

public class ModuleConfigurationManager {
    private static final System.Logger LOG = System.getLogger(ModuleConfigurationManager.class.getName());
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final OperationLock operationLock = new OperationLock(this.readWriteLock);
    private ConfigParser parser;
    private AuthConfigFactory factory;
    private AuthConfigProvider defaultProvider;
    private final Map<String, String> layerToDefaultProviderRegistrationMap = new HashMap<String, String>();

    public ModuleConfigurationManager(ConfigParser initParser, AuthConfigFactory initFactory, AuthConfigProvider initProvider) {
        this.init(initParser, initFactory, initProvider);
    }

    public void init(String initParserClassName, AuthConfigFactory initFactory, AuthConfigProvider initProvider) {
        this.init((ConfigParser)ObjectUtils.createObject(initParserClassName), initFactory, initProvider);
    }

    public void init(ConfigParser initParser, AuthConfigFactory initFactory, AuthConfigProvider initProvider) {
        this.operationLock.doLocked(() -> this.parser == null, () -> {
            this.parser = initParser;
            this.loadParser(initProvider, initFactory, null);
        });
        if (initFactory != null) {
            this.operationLock.doLocked(() -> this.factory == null, () -> {
                this.factory = initFactory;
            });
        }
        if (initProvider != null) {
            this.operationLock.doLocked(() -> this.defaultProvider == null, () -> {
                this.defaultProvider = initProvider;
            });
        }
    }

    public void loadConfigContext(Object config) {
        if (this.defaultProvider == null) {
            LOG.log(System.Logger.Level.ERROR, "unableToLoad.noGlobalProvider");
            return;
        }
        if (!this.operationLock.doReadLocked(() -> this.factory != null).booleanValue()) {
            this.operationLock.doWriteLocked(() -> {
                if (this.factory == null) {
                    this.factory = AuthConfigFactory.getFactory();
                }
            });
        }
        this.loadParser(this.defaultProvider, this.factory, config);
    }

    public void loadParser(AuthConfigProvider defaultConfigProvider, AuthConfigFactory factory, Object config) {
        this.operationLock.doWriteLocked(() -> {
            try {
                this.parser.initialize(config);
                if (factory != null && defaultConfigProvider != null) {
                    this.updateDefaultProviderForSupportedLayers(defaultConfigProvider, factory);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public AuthModuleInstanceHolder createAuthModuleInstance(AuthModuleBaseConfig authModuleConfig, CallbackHandler handler, String moduleType, Map<String, Object> properties) throws AuthException {
        try {
            Object newModule = ObjectUtils.newAuthModule(authModuleConfig.getModuleClassName());
            Map<String, Object> moduleOptions = this.mergeModuleOptions(properties, authModuleConfig.getOptions());
            if ("server".equals(moduleType)) {
                ((ServerAuthModule)newModule).initialize(authModuleConfig.getRequestPolicy(), authModuleConfig.getResponsePolicy(), handler, moduleOptions);
            } else {
                ((ClientAuthModule)newModule).initialize(authModuleConfig.getRequestPolicy(), authModuleConfig.getResponsePolicy(), handler, moduleOptions);
            }
            return new AuthModuleInstanceHolder(newModule, moduleOptions);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                throw (AuthException)e;
            }
            throw (AuthException)new AuthException().initCause(e);
        }
    }

    public AuthModuleBaseConfig getAuthModuleConfig(String layer, String authModuleId, MessagePolicy requestPolicyIn, MessagePolicy responsePolicyIn, String authModuleType) {
        Map authModuleLayers = this.operationLock.doReadLocked(() -> this.parser.getAuthModuleLayers());
        if (authModuleLayers == null) {
            return null;
        }
        AuthModulesLayerConfig authModulesLayerConfig = (AuthModulesLayerConfig)authModuleLayers.get(layer);
        if (authModulesLayerConfig == null || authModulesLayerConfig.getAuthModules() == null) {
            LOG.log(System.Logger.Level.DEBUG, "Module config has no auth modules configured for layer [{0}]", layer);
            return null;
        }
        AuthModuleConfig authModuleConfig = null;
        if (authModuleId == null || (authModuleConfig = authModulesLayerConfig.getAuthModules().get(authModuleId)) == null) {
            LOG.log(System.Logger.Level.DEBUG, "DD did not specify auth module Id, or DD-specified Id for layer [{0}] not found in config -- attempting to look for default auth moduke Id", layer);
            String defaultModuleID = this.getDefaultModuleId(authModuleType, authModulesLayerConfig);
            authModuleConfig = authModulesLayerConfig.getAuthModules().get(defaultModuleID);
            if (authModuleConfig == null) {
                LOG.log(System.Logger.Level.DEBUG, "No default config Id for layer [{0}]", layer);
                return null;
            }
        }
        if (authModuleConfig.getType().indexOf(authModuleType) < 0) {
            LOG.log(System.Logger.Level.DEBUG, "Request type [{0}] does not match config type [{1}]", authModuleType, authModuleConfig.getType());
            return null;
        }
        MessagePolicy requestPolicy = this.getRequestPolicy(requestPolicyIn, responsePolicyIn, authModuleConfig);
        MessagePolicy responsePolicy = this.getResponsePolicy(requestPolicyIn, responsePolicyIn, authModuleConfig);
        if (requestPolicy == null && responsePolicy == null) {
            LOG.log(System.Logger.Level.DEBUG, "no policy applies");
            return null;
        }
        AuthModuleBaseConfig newAuthModuleConfig = new AuthModuleBaseConfig(authModuleConfig.getModuleClassName(), requestPolicy, responsePolicy, authModuleConfig.getOptions());
        LOG.log(System.Logger.Level.DEBUG, () -> "getEntry for: " + layer + " -- " + authModuleId + "\n    module class: " + newAuthModuleConfig.getModuleClassName() + "\n    options: " + String.valueOf(newAuthModuleConfig.getOptions()) + "\n    request policy: " + String.valueOf(newAuthModuleConfig.getRequestPolicy()) + "\n    response policy: " + String.valueOf(newAuthModuleConfig.getResponsePolicy()));
        return newAuthModuleConfig;
    }

    private String getDefaultModuleId(String authModuleType, AuthModulesLayerConfig authModulesLayerConfig) {
        if ("client".equals(authModuleType)) {
            return authModulesLayerConfig.getDefaultClientModuleId();
        }
        return authModulesLayerConfig.getDefaultServerModuleId();
    }

    private MessagePolicy getRequestPolicy(MessagePolicy requestPolicy, MessagePolicy responsePolicy, AuthModuleConfig authModuleConfig) {
        return requestPolicy != null || responsePolicy != null ? requestPolicy : authModuleConfig.getRequestPolicy();
    }

    private MessagePolicy getResponsePolicy(MessagePolicy requestPolicy, MessagePolicy responsePolicy, AuthModuleConfig authModuleConfig) {
        return requestPolicy != null || responsePolicy != null ? responsePolicy : authModuleConfig.getResponsePolicy();
    }

    private Map<String, Object> mergeModuleOptions(Map<String, Object> moduleOptions, Map<String, Object> configuredModuleOptions) {
        Map<String, Object> mergedModuleOptions = moduleOptions;
        if (configuredModuleOptions != null) {
            mergedModuleOptions = mergedModuleOptions == null ? new HashMap<String, Object>() : new HashMap<String, Object>(moduleOptions);
            mergedModuleOptions.putAll(configuredModuleOptions);
        }
        return mergedModuleOptions;
    }

    private void updateDefaultProviderForSupportedLayers(AuthConfigProvider defaultConfigProvider, AuthConfigFactory factory) {
        Set<String> layers = this.parser.getLayersWithDefault();
        for (String layer : this.layerToDefaultProviderRegistrationMap.keySet()) {
            if (layers.contains(layer)) continue;
            factory.removeRegistration(this.layerToDefaultProviderRegistrationMap.remove(layer));
        }
        for (String layer : layers) {
            if (this.layerToDefaultProviderRegistrationMap.containsKey(layer)) continue;
            this.layerToDefaultProviderRegistrationMap.put(layer, factory.registerConfigProvider(defaultConfigProvider, layer, null, "GFServerConfigProvider: self registration"));
        }
    }
}

