/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.factory;

import jakarta.security.auth.message.config.AuthConfigFactory;
import org.glassfish.epicyro.config.factory.file.AuthConfigProviderEntry;

public final class RegistrationContextImpl
implements AuthConfigFactory.RegistrationContext {
    private final String messageLayer;
    private final String appContext;
    private final String description;
    private final boolean isPersistent;

    public RegistrationContextImpl(String messageLayer, String appContext, String description, boolean persistent) {
        this.messageLayer = messageLayer;
        this.appContext = appContext;
        this.description = description;
        this.isPersistent = persistent;
    }

    public RegistrationContextImpl(AuthConfigFactory.RegistrationContext registrationContext) {
        this.messageLayer = registrationContext.getMessageLayer();
        this.appContext = registrationContext.getAppContext();
        this.description = registrationContext.getDescription();
        this.isPersistent = registrationContext.isPersistent();
    }

    @Override
    public String getMessageLayer() {
        return this.messageLayer;
    }

    @Override
    public String getAppContext() {
        return this.appContext;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isPersistent() {
        return this.isPersistent;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AuthConfigFactory.RegistrationContext)) {
            return false;
        }
        AuthConfigFactory.RegistrationContext target = (AuthConfigFactory.RegistrationContext)o;
        return AuthConfigProviderEntry.matchStrings(this.messageLayer, target.getMessageLayer()) && AuthConfigProviderEntry.matchStrings(this.appContext, target.getAppContext()) && this.isPersistent() == target.isPersistent();
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.messageLayer != null ? this.messageLayer.hashCode() : 0);
        hash = 17 * hash + (this.appContext != null ? this.appContext.hashCode() : 0);
        hash = 17 * hash + (this.isPersistent ? 1 : 0);
        return hash;
    }
}

