/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.util;

import com.sun.corba.ee.spi.threadpool.NoSuchThreadPoolException;
import com.sun.corba.ee.spi.threadpool.ThreadPoolChooser;
import com.sun.corba.ee.spi.threadpool.ThreadPoolFactory;
import com.sun.corba.ee.spi.threadpool.ThreadPoolManager;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.util.IIOPUtils;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.internal.api.Globals;

public class S1ASThreadPoolManager
implements ThreadPoolManager {
    private static final Logger LOG = LogDomains.getLogger(S1ASThreadPoolManager.class, "jakarta.enterprise.resource.corba", false);
    private static final int DEFAULT_MIN_THREAD_COUNT = 10;
    private static final int DEFAULT_MAX_THREAD_COUNT = 200;
    private static HashMap<String, Integer> idToIndexTable = new HashMap();
    private static HashMap<Integer, String> indexToIdTable = new HashMap();
    private static ArrayList<com.sun.corba.ee.spi.threadpool.ThreadPool> threadpoolList = new ArrayList();
    private static String defaultID;
    private static ThreadPoolManager s1asThreadPoolMgr;
    private static IIOPUtils _iiopUtils;

    public static ThreadPoolManager getThreadPoolManager() {
        return s1asThreadPoolMgr;
    }

    S1ASThreadPoolManager() {
    }

    private static void createThreadPools(ThreadPool threadpoolBean, int index) {
        String threadpoolId = null;
        int minThreads = 10;
        int maxThreads = 200;
        int idleTimeoutInSeconds = 120000;
        try {
            threadpoolId = threadpoolBean.getName();
        }
        catch (NullPointerException npe) {
            LOG.log(Level.WARNING, "ThreadPoolBean may be null ", npe);
        }
        try {
            String minThreadsValue = threadpoolBean.getMinThreadPoolSize();
            minThreads = Integer.parseInt(minThreadsValue);
        }
        catch (NullPointerException npe) {
            LOG.log(Level.WARNING, "ThreadPoolBean may be null ", npe);
            LOG.log(Level.WARNING, "Using default value for steady-threadpool-size = {0}", minThreads);
        }
        catch (NumberFormatException nfe) {
            LOG.log(Level.WARNING, "Number Format Exception, Using default value(s)", nfe);
            LOG.log(Level.WARNING, "Using default value for min-threadpool-size = {0}", minThreads);
        }
        try {
            String maxThreadsValue = threadpoolBean.getMaxThreadPoolSize();
            maxThreads = Integer.parseInt(maxThreadsValue);
        }
        catch (NullPointerException npe) {
            LOG.log(Level.WARNING, "ThreadPoolBean may be null ", npe);
            LOG.log(Level.WARNING, "Using default value for max-threadpool-size = " + maxThreads);
        }
        catch (NumberFormatException nfe) {
            LOG.log(Level.WARNING, "Number Format Exception, Using default value(s)", nfe);
            LOG.log(Level.WARNING, "Using default value for max-threadpool-size = {0}", maxThreads);
        }
        try {
            String timeoutValue = threadpoolBean.getIdleThreadTimeoutSeconds();
            idleTimeoutInSeconds = Integer.parseInt(timeoutValue);
        }
        catch (NullPointerException npe) {
            LOG.log(Level.WARNING, "ThreadPoolBean may be null ", npe);
            LOG.log(Level.WARNING, "Using default value for idle-thread-timeout-in-seconds = {0}", idleTimeoutInSeconds);
        }
        catch (NumberFormatException nfe) {
            LOG.log(Level.WARNING, "Number Format Exception, Using default value(s)", nfe);
            LOG.log(Level.WARNING, "Using default value for idle-thread-timeout-in-seconds = {0}", idleTimeoutInSeconds);
        }
        ThreadPoolFactory threadPoolFactory = new ThreadPoolFactory();
        com.sun.corba.ee.spi.threadpool.ThreadPool threadpool = threadPoolFactory.create(minThreads, maxThreads, (long)idleTimeoutInSeconds * 1000L, threadpoolId, _iiopUtils.getCommonClassLoader());
        threadpoolList.add(threadpool);
        idToIndexTable.put(threadpoolId, index);
        indexToIdTable.put(index, threadpoolId);
    }

    @Override
    public com.sun.corba.ee.spi.threadpool.ThreadPool getThreadPool(String id) throws NoSuchThreadPoolException {
        Integer i = idToIndexTable.get(id);
        if (i == null) {
            throw new NoSuchThreadPoolException();
        }
        try {
            com.sun.corba.ee.spi.threadpool.ThreadPool threadpool = threadpoolList.get(i);
            return threadpool;
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new NoSuchThreadPoolException();
        }
    }

    @Override
    public com.sun.corba.ee.spi.threadpool.ThreadPool getThreadPool(int numericIdForThreadpool) throws NoSuchThreadPoolException {
        try {
            com.sun.corba.ee.spi.threadpool.ThreadPool threadpool = threadpoolList.get(numericIdForThreadpool);
            return threadpool;
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new NoSuchThreadPoolException();
        }
    }

    @Override
    public int getThreadPoolNumericId(String id) {
        Integer i = idToIndexTable.get(id);
        return i == null ? 0 : i;
    }

    @Override
    public String getThreadPoolStringId(int numericIdForThreadpool) {
        String id = indexToIdTable.get(numericIdForThreadpool);
        return id == null ? defaultID : id;
    }

    @Override
    public com.sun.corba.ee.spi.threadpool.ThreadPool getDefaultThreadPool() {
        try {
            return this.getThreadPool(0);
        }
        catch (NoSuchThreadPoolException nstpe) {
            LOG.log(Level.WARNING, "No default ThreadPool defined ", nstpe);
            return null;
        }
    }

    @Override
    public ThreadPoolChooser getThreadPoolChooser(String componentId) {
        return null;
    }

    @Override
    public ThreadPoolChooser getThreadPoolChooser(int componentIndex) {
        return null;
    }

    @Override
    public void setThreadPoolChooser(String componentId, ThreadPoolChooser aThreadPoolChooser) {
    }

    @Override
    public int getThreadPoolChooserNumericId(String componentId) {
        return 0;
    }

    @Override
    public void close() {
    }

    static {
        s1asThreadPoolMgr = new S1ASThreadPoolManager();
        try {
            _iiopUtils = Globals.getDefaultHabitat().getService(IIOPUtils.class, new Annotation[0]);
            Collection<ThreadPool> tpCol = _iiopUtils.getAllThreadPools();
            ThreadPool[] allThreadPools = tpCol.toArray(new ThreadPool[tpCol.size()]);
            for (int i = 0; i < allThreadPools.length; ++i) {
                S1ASThreadPoolManager.createThreadPools(allThreadPools[i], i);
            }
            defaultID = indexToIdTable.get(0);
        }
        catch (NullPointerException npe) {
            LOG.log(Level.FINE, "Server Context is NULL. Ignoring and proceeding.");
        }
    }
}

