/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.util;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ServerRef;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.enterprise.iiop.api.GlassFishORBLifeCycleListener;
import org.glassfish.enterprise.iiop.api.IIOPInterceptorFactory;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.orb.admin.config.IiopListener;
import org.glassfish.orb.admin.config.IiopService;
import org.jvnet.hk2.annotations.Service;
import org.omg.CORBA.ORB;

@Service
public class IIOPUtils
implements PostConstruct {
    private static IIOPUtils _me;
    @Inject
    ServiceLocator services;
    @Inject
    private ClassLoaderHierarchy clHierarchy;
    @Inject
    private ProcessEnvironment processEnv;
    private ProcessEnvironment.ProcessType processType;
    private Collection<ThreadPool> threadPools;
    private IiopService iiopService;
    private Collection<ServerRef> serverRefs;
    private ORB defaultORB;

    @Override
    public void postConstruct() {
        this.processType = this.processEnv.getProcessType();
        if (this.processEnv.getProcessType().isServer()) {
            Config c = this.services.getService(Config.class, "default-instance-name", new Annotation[0]);
            this.iiopService = c.getExtensionByType(IiopService.class);
            List<ThreadPool> threadPool = c.getThreadPools().getThreadPool();
            Collection<NetworkListener> listeners = this.allByContract(NetworkListener.class);
            TreeSet<String> names = new TreeSet<String>();
            this.threadPools = new ArrayList<ThreadPool>();
            for (NetworkListener listener : listeners) {
                names.add(listener.getThreadPool());
            }
            for (ThreadPool pool : threadPool) {
                if (names.contains(pool.getName())) continue;
                this.threadPools.add(pool);
            }
            this.serverRefs = this.allByContract(ServerRef.class);
        }
        IIOPUtils.initMe(this);
    }

    private static void initMe(IIOPUtils utils) {
        _me = utils;
    }

    public static IIOPUtils getInstance() {
        return _me;
    }

    public static void setInstance(IIOPUtils utils) {
        _me = utils;
    }

    public ClassLoader getCommonClassLoader() {
        return this.clHierarchy.getCommonClassLoader();
    }

    private void assertServer() {
        if (!this.processType.isServer()) {
            throw new IllegalStateException("Only available in Server mode");
        }
    }

    public IiopService getIiopService() {
        this.assertServer();
        return this.iiopService;
    }

    public Collection<ThreadPool> getAllThreadPools() {
        this.assertServer();
        return this.threadPools;
    }

    public Collection<ServerRef> getServerRefs() {
        this.assertServer();
        return this.serverRefs;
    }

    public List<IiopListener> getIiopListeners() {
        this.assertServer();
        return this.iiopService.getIiopListener();
    }

    public Collection<IIOPInterceptorFactory> getAllIIOPInterceptrFactories() {
        return this.allByContract(IIOPInterceptorFactory.class);
    }

    public Collection<GlassFishORBLifeCycleListener> getGlassFishORBLifeCycleListeners() {
        return this.allByContract(GlassFishORBLifeCycleListener.class);
    }

    public ProcessEnvironment.ProcessType getProcessType() {
        return this.processType;
    }

    public ServiceLocator getHabitat() {
        return this.services;
    }

    public void setORB(ORB orb) {
        this.defaultORB = orb;
    }

    public ORB getORB() {
        return this.defaultORB;
    }

    private <T> Collection<T> allByContract(Class<T> contractClass) {
        return this.services.getAllServices(contractClass, new Annotation[0]);
    }
}

