/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.api;

import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.nio.channels.SelectableChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.internal.grizzly.LazyServiceInitializer;
import org.jvnet.hk2.annotations.Service;

@Service
@Named(value="iiop-service")
public class ORBLazyServiceInitializer
implements LazyServiceInitializer,
PostConstruct {
    private static final Logger LOG = LogDomains.getLogger(ORBLazyServiceInitializer.class, "jakarta.enterprise.system", false);
    @Inject
    private GlassFishORBHelper orbHelper;
    boolean initializedSuccessfully;

    @Override
    public void postConstruct() {
    }

    public String getServiceName() {
        return "iiop-service";
    }

    @Override
    public boolean initializeService() {
        try {
            this.orbHelper.getORB();
            this.initializedSuccessfully = true;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "ORB initialization failed in lazy init", e);
        }
        return this.initializedSuccessfully;
    }

    @Override
    public void handleRequest(SelectableChannel channel) {
        if (this.initializedSuccessfully) {
            this.orbHelper.getSelectableChannelDelegate().handleRequest(channel);
        } else {
            LOG.log(Level.WARNING, "Cannot handle SelectableChannel request in ORBLazyServiceInitializer. ORB did not initialize successfully");
        }
    }
}

