/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.upgrade;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.ejb.config.EjbContainer;
import org.glassfish.ejb.config.EjbTimerService;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="ejbTimerServiceUpgrade")
public class EJBTimerServiceUpgrade
implements PostConstruct,
ConfigurationUpgrade {
    @Inject
    Configs configs;

    @Override
    public void postConstruct() {
        for (Config config : this.configs.getConfig()) {
            EjbContainer container = config.getExtensionByType(EjbContainer.class);
            if (container == null || container.getEjbTimerService() == null) continue;
            this.doUpgrade(container.getEjbTimerService());
        }
    }

    private void doUpgrade(EjbTimerService ts) {
        List<Property> properties;
        String value = ts.getMinimumDeliveryIntervalInMillis();
        if (value == null || "7000".equals(value)) {
            value = "1000";
        }
        if ((properties = ts.getProperty()) != null) {
            for (Property p : properties) {
                if (!p.getName().equals("ejb-timer-service-upgraded")) continue;
                return;
            }
        }
        try {
            final String minDelivery = value;
            ConfigSupport.apply(new SingleConfigCode<EjbTimerService>(){

                @Override
                public Object run(EjbTimerService ts) throws PropertyVetoException, TransactionFailure {
                    Property prop = ts.createChild(Property.class);
                    ts.getProperty().add(prop);
                    prop.setName("ejb-timer-service-upgraded");
                    prop.setValue("false");
                    ts.setMinimumDeliveryIntervalInMillis(minDelivery);
                    return null;
                }
            }, ts);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

