/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.security.application;

import com.sun.ejb.EjbInvocation;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.ComponentInvocationHandler;
import org.glassfish.api.invocation.InvocationException;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.invocation.RegisteredComponentInvocationHandler;
import org.jvnet.hk2.annotations.Service;

@Service(name="ejbSecurityCIH")
@Singleton
public class EjbSecurityComponentInvocationHandler
implements RegisteredComponentInvocationHandler {
    private static final Logger _logger = LogDomains.getLogger(EjbSecurityComponentInvocationHandler.class, "jakarta.enterprise.system.container.ejb");
    @Inject
    private InvocationManager invocationManager;
    private final ComponentInvocationHandler ejbSecurityCompInvHandler = new ComponentInvocationHandler(this){

        @Override
        public void beforePreInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation newInv) throws InvocationException {
            if (invType == ComponentInvocation.ComponentInvocationType.EJB_INVOCATION) {
                try {
                    if (!newInv.isPreInvokeDone()) {
                        ((EjbInvocation)newInv).getEjbSecurityManager().preInvoke(newInv);
                    }
                }
                catch (Exception ex) {
                    _logger.log(Level.SEVERE, "ejb.security_preinvoke_exception", ex);
                    throw new InvocationException(ex);
                }
            }
        }

        @Override
        public void afterPreInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
        }

        @Override
        public void beforePostInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
        }

        @Override
        public void afterPostInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
            if (invType == ComponentInvocation.ComponentInvocationType.EJB_INVOCATION) {
                try {
                    ((EjbInvocation)curInv).getEjbSecurityManager().postInvoke(curInv);
                }
                catch (Exception ex) {
                    _logger.log(Level.SEVERE, "Exception while running postInvoke for invType=" + String.valueOf((Object)invType) + " and invocation=" + String.valueOf(curInv), ex);
                    ((EjbInvocation)curInv).exception = ex;
                }
            }
        }
    };

    @Override
    public ComponentInvocationHandler getComponentInvocationHandler() {
        return this.ejbSecurityCompInvHandler;
    }

    @Override
    public void register() {
        this.invocationManager.registerComponentInvocationHandler(ComponentInvocation.ComponentInvocationType.EJB_INVOCATION, this);
    }
}

