/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.util;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.MessageDestinationReferencer;
import com.sun.enterprise.deployment.util.EjbBundleVisitor;
import com.sun.enterprise.deployment.util.TracerVisitor;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.glassfish.ejb.deployment.descriptor.ContainerTransaction;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.FieldDescriptor;
import org.glassfish.ejb.deployment.descriptor.PersistenceDescriptor;
import org.glassfish.ejb.deployment.descriptor.QueryDescriptor;
import org.glassfish.ejb.deployment.descriptor.RelationshipDescriptor;

public class EjbBundleTracerVisitor
extends TracerVisitor
implements EjbBundleVisitor {
    private static final System.Logger LOG = System.getLogger(EjbBundleTracerVisitor.class.getName());

    @Override
    public void accept(BundleDescriptor bundle2) {
        LOG.log(System.Logger.Level.INFO, "accept(bundle.name={0})", bundle2.getName());
        if (bundle2 instanceof EjbBundleDescriptorImpl) {
            EjbBundleDescriptorImpl ejbBundle = (EjbBundleDescriptorImpl)bundle2;
            this.accept(ejbBundle);
            for (EjbDescriptor anEjb : ejbBundle.getEjbs()) {
                anEjb.visit(this.getSubDescriptorVisitor(anEjb));
            }
            if (ejbBundle.hasRelationships()) {
                for (RelationshipDescriptor rd : ejbBundle.getRelationships()) {
                    this.accept(rd);
                }
            }
            for (WebService ws : ejbBundle.getWebServices().getWebServices()) {
                this.accept(ws);
            }
        }
        super.accept(bundle2);
    }

    @Override
    public void accept(EjbBundleDescriptor bundle2) {
        LOG.log(System.Logger.Level.INFO, "accept(bundle.name={0})", bundle2.getName());
    }

    protected void accept(EjbDescriptor ejb) {
        Object msgDestReferencer;
        LOG.log(System.Logger.Level.INFO, "accept ejb:\n{0}", ejb);
        for (EjbReference ejbReference : ejb.getEjbReferenceDescriptors()) {
            this.accept(ejbReference);
        }
        for (MethodPermission methodPermission : ejb.getPermissionedMethodsByPermission().keySet()) {
            Set<MethodDescriptor> set = ejb.getPermissionedMethodsByPermission().get(methodPermission);
            this.accept(methodPermission, set);
        }
        Map<MethodPermission, Set<MethodDescriptor>> methodPerms = ejb.getStyledPermissionedMethodsByPermission();
        if (methodPerms != null) {
            for (Map.Entry<MethodPermission, Set<MethodDescriptor>> entry : methodPerms.entrySet()) {
                this.accept(entry.getKey(), (Collection<MethodDescriptor>)entry.getValue());
            }
        }
        for (RoleReference roleReference : ejb.getRoleReferences()) {
            this.accept(roleReference);
        }
        for (Map.Entry<MethodDescriptor, ContainerTransaction> entry : ejb.getMethodContainerTransactions().entrySet()) {
            this.accept(entry.getKey(), entry.getValue());
        }
        for (EnvironmentProperty environmentProperty : ejb.getEnvironmentProperties()) {
            this.accept(environmentProperty);
        }
        for (ResourceReferenceDescriptor resourceReferenceDescriptor : ejb.getResourceReferenceDescriptors()) {
            this.accept(resourceReferenceDescriptor);
        }
        for (ResourceEnvReferenceDescriptor resourceEnvReferenceDescriptor : ejb.getResourceEnvReferenceDescriptors()) {
            this.accept(resourceEnvReferenceDescriptor);
        }
        for (MessageDestinationReferencer messageDestinationReferencer : ejb.getMessageDestinationReferenceDescriptors()) {
            this.accept(messageDestinationReferencer);
        }
        if ("Message-driven".equals(ejb.getType()) && (msgDestReferencer = (MessageDestinationReferencer)((Object)ejb)).getMessageDestinationLinkName() != null) {
            this.accept((MessageDestinationReferencer)msgDestReferencer);
        }
        for (ServiceReferenceDescriptor serviceReferenceDescriptor : ejb.getServiceReferenceDescriptors()) {
            this.accept(serviceReferenceDescriptor);
        }
        if (ejb instanceof EjbCMPEntityDescriptor) {
            EjbCMPEntityDescriptor cmp = (EjbCMPEntityDescriptor)ejb;
            PersistenceDescriptor persistenceDescriptor = cmp.getPersistenceDescriptor();
            for (FieldDescriptor field : persistenceDescriptor.getCMPFields()) {
                this.accept(field);
            }
            for (MethodDescriptor method : persistenceDescriptor.getQueriedMethods()) {
                QueryDescriptor qd = persistenceDescriptor.getQueryFor(method);
                this.accept(qd);
            }
        }
    }

    protected void accept(MethodPermission methodPermission, Collection<MethodDescriptor> methodDescriptors) {
        LOG.log(System.Logger.Level.INFO, "accept(methodPermission={0}, methods)", methodPermission);
    }

    protected void accept(RoleReference reference) {
        LOG.log(System.Logger.Level.INFO, "accept(reference={0})", reference);
    }

    protected void accept(MethodDescriptor method, ContainerTransaction transaction) {
        LOG.log(System.Logger.Level.INFO, "accept(method={0}, transaction={1})", method, transaction);
    }

    protected void accept(FieldDescriptor field) {
        LOG.log(System.Logger.Level.INFO, "accept(field={0})", field);
    }

    protected void accept(QueryDescriptor query) {
        LOG.log(System.Logger.Level.INFO, "accept(query={0})", query);
    }

    protected void accept(RelationshipDescriptor rd) {
        LOG.log(System.Logger.Level.INFO, () -> "accept relationship:\nFrom EJB " + rd.getSource().getName() + " cmr field: " + rd.getSource().getCMRField() + "(" + rd.getSource().getCMRFieldType() + ")  to EJB " + rd.getSink().getName() + " isMany " + rd.getSource().getIsMany() + " cascade-delete " + rd.getSource().getCascadeDelete() + "\nTo  EJB " + rd.getSink().getName() + " isMany " + rd.getSink().getIsMany() + " cascade-delete " + rd.getSink().getCascadeDelete() + "\nBidirectional cmr field: " + (String)(rd.getIsBidirectional() ? rd.getSink().getCMRField() + "(" + rd.getSink().getCMRFieldType() + ")" : "false"));
    }
}

