/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node.runtime;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Set;
import org.glassfish.ejb.deployment.descriptor.ActivationConfigDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbMessageBeanDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ActivationConfigNode
extends DeploymentDescriptorNode<ActivationConfigDescriptor> {
    private ActivationConfigDescriptor descriptor;
    private String propertyName;

    public ActivationConfigNode() {
        this.registerElementHandler(new XMLElement("activation-config"), ActivationConfigNode.class, "setRuntimeActivationConfigDescriptor");
    }

    @Override
    public ActivationConfigDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = ((EjbMessageBeanDescriptor)this.getParentNode().getDescriptor()).getRuntimeActivationConfigDescriptor();
        }
        return this.descriptor;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("activation-config-property-name".equals(element.getQName())) {
            this.propertyName = value;
        } else if ("activation-config-property-value".equals(element.getQName())) {
            EnvironmentProperty prop = new EnvironmentProperty(this.propertyName, value, "");
            this.descriptor.getActivationConfig().add(prop);
            this.propertyName = null;
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, ActivationConfigDescriptor descriptor) {
        Element activationConfigNode = null;
        Set<EnvironmentProperty> activationConfig = descriptor.getActivationConfig();
        if (!activationConfig.isEmpty()) {
            activationConfigNode = ActivationConfigNode.appendChild(parent, nodeName);
            for (EnvironmentProperty next : activationConfig) {
                Element activationConfigPropertyNode = ActivationConfigNode.appendChild(activationConfigNode, "activation-config-property");
                ActivationConfigNode.appendTextChild((Node)activationConfigPropertyNode, "activation-config-property-name", next.getName());
                ActivationConfigNode.appendTextChild((Node)activationConfigPropertyNode, "activation-config-property-value", next.getValue());
            }
        }
        return activationConfigNode;
    }
}

