/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node;

import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.ejb.deployment.descriptor.QueryDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QueryNode
extends DeploymentDescriptorNode<QueryDescriptor> {
    private QueryDescriptor descriptor;

    public QueryNode() {
        this.registerElementHandler(new XMLElement("query-method"), MethodNode.class, "setQueryMethodDescriptor");
    }

    @Override
    public QueryDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new QueryDescriptor();
        }
        return this.descriptor;
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("ejb-ql", "setQuery");
        return table;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("result-type-mapping".equals(element.getQName())) {
            if ("Remote".equals(value)) {
                this.descriptor.setHasRemoteReturnTypeMapping();
            } else if ("Local".equals(value)) {
                this.descriptor.setHasLocalReturnTypeMapping();
            } else {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "AS-DEPLOYMENT-00015", new Object[]{((Descriptor)this.getParentNode().getDescriptor()).getName(), value, this.descriptor.getClass()});
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, QueryDescriptor descriptor) {
        Node queryNode = super.writeDescriptor(parent, nodeName, descriptor);
        QueryNode.writeLocalizedDescriptions(queryNode, descriptor);
        MethodNode methodNode = new MethodNode();
        methodNode.writeQueryMethodDescriptor(queryNode, "query-method", descriptor.getQueryMethodDescriptor());
        if (descriptor.getHasRemoteReturnTypeMapping()) {
            QueryNode.appendTextChild(queryNode, "result-type-mapping", "Remote");
        } else if (descriptor.getHasLocalReturnTypeMapping()) {
            QueryNode.appendTextChild(queryNode, "result-type-mapping", "Local");
        }
        String ejbqlText = descriptor.getIsEjbQl() ? descriptor.getQuery() : "";
        Element child = QueryNode.appendChild(queryNode, "ejb-ql");
        child.appendChild(QueryNode.getOwnerDocument(child).createTextNode(ejbqlText));
        return queryNode;
    }
}

