/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node;

import com.sun.enterprise.deployment.EjbApplicationExceptionInfo;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.MethodPermissionDescriptor;
import com.sun.enterprise.deployment.node.AbstractBundleNode;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.MessageDestinationNode;
import com.sun.enterprise.deployment.node.SaxParserHandler;
import com.sun.enterprise.deployment.node.SecurityRoleNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbMessageBeanDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.glassfish.ejb.deployment.descriptor.RelationshipDescriptor;
import org.glassfish.ejb.deployment.node.ContainerTransactionNode;
import org.glassfish.ejb.deployment.node.EjbApplicationExceptionNode;
import org.glassfish.ejb.deployment.node.EjbEntityNode;
import org.glassfish.ejb.deployment.node.EjbInterceptorNode;
import org.glassfish.ejb.deployment.node.EjbNode;
import org.glassfish.ejb.deployment.node.EjbSessionNode;
import org.glassfish.ejb.deployment.node.ExcludeListNode;
import org.glassfish.ejb.deployment.node.InterceptorBindingNode;
import org.glassfish.ejb.deployment.node.MessageDrivenBeanNode;
import org.glassfish.ejb.deployment.node.MethodPermissionNode;
import org.glassfish.ejb.deployment.node.RelationshipsNode;
import org.glassfish.ejb.deployment.node.runtime.EjbBundleRuntimeNode;
import org.glassfish.ejb.deployment.node.runtime.GFEjbBundleRuntimeNode;
import org.glassfish.security.common.Role;
import org.jvnet.hk2.annotations.Service;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Service
public class EjbBundleNode
extends AbstractBundleNode<EjbBundleDescriptorImpl> {
    private static final XMLElement tag = new XMLElement("ejb-jar");
    private static final String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    private static final String PUBLIC_DTD_ID_12 = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    private static final String SYSTEM_ID = "http://java.sun.com/dtd/ejb-jar_2_0.dtd";
    private static final String SYSTEM_ID_12 = "http://java.sun.com/dtd/ejb-jar_1_1.dtd";
    private static final String SCHEMA_ID_21 = "ejb-jar_2_1.xsd";
    private static final String SCHEMA_ID_30 = "ejb-jar_3_0.xsd";
    private static final String SCHEMA_ID_31 = "ejb-jar_3_1.xsd";
    private static final String SCHEMA_ID_32 = "ejb-jar_3_2.xsd";
    private static final String SCHEMA_ID = "ejb-jar_4_0.xsd";
    public static final String SPEC_VERSION = "4.0";
    private static final List<String> SYSTEM_IDS = List.of("ejb-jar_4_0.xsd", "ejb-jar_3_2.xsd", "ejb-jar_3_1.xsd", "ejb-jar_3_0.xsd", "ejb-jar_2_1.xsd");
    private EjbBundleDescriptorImpl descriptor;

    @Override
    public String registerBundle(Map<String, String> publicIDToDTD) {
        publicIDToDTD.put(PUBLIC_DTD_ID, SYSTEM_ID);
        publicIDToDTD.put(PUBLIC_DTD_ID_12, SYSTEM_ID_12);
        return tag.getQName();
    }

    @Override
    public Map<String, Class<?>> registerRuntimeBundle(Map<String, String> publicIDToDTD, Map<String, List<Class<?>>> versionUpgrades) {
        HashMap result = new HashMap();
        result.put(EjbBundleRuntimeNode.registerBundle(publicIDToDTD), EjbBundleRuntimeNode.class);
        result.put(GFEjbBundleRuntimeNode.registerBundle(publicIDToDTD), GFEjbBundleRuntimeNode.class);
        return result;
    }

    public EjbBundleNode() {
        this.registerElementHandler(new XMLElement("session"), EjbSessionNode.class);
        this.registerElementHandler(new XMLElement("entity"), EjbEntityNode.class);
        this.registerElementHandler(new XMLElement("message-driven"), MessageDrivenBeanNode.class);
        this.registerElementHandler(new XMLElement("method-permission"), MethodPermissionNode.class);
        this.registerElementHandler(new XMLElement("security-role"), SecurityRoleNode.class, "addRole");
        this.registerElementHandler(new XMLElement("container-transaction"), ContainerTransactionNode.class);
        this.registerElementHandler(new XMLElement("exclude-list"), ExcludeListNode.class);
        this.registerElementHandler(new XMLElement("relationships"), RelationshipsNode.class);
        this.registerElementHandler(new XMLElement("message-destination"), MessageDestinationNode.class, "addMessageDestination");
        this.registerElementHandler(new XMLElement("application-exception"), EjbApplicationExceptionNode.class, "addApplicationException");
        this.registerElementHandler(new XMLElement("interceptor"), EjbInterceptorNode.class, "addInterceptor");
        this.registerElementHandler(new XMLElement("interceptor-binding"), InterceptorBindingNode.class, "appendInterceptorBinding");
        SaxParserHandler.registerBundleNode(this, "ejb-jar");
    }

    @Override
    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof EjbDescriptor) {
            this.descriptor.addEjb((EjbDescriptor)newDescriptor);
        } else if (newDescriptor instanceof RelationshipDescriptor) {
            this.descriptor.addRelationship((RelationshipDescriptor)newDescriptor);
        } else if (newDescriptor instanceof MethodPermissionDescriptor) {
            MethodDescriptor[] array;
            MethodPermissionDescriptor nd = (MethodPermissionDescriptor)newDescriptor;
            for (MethodDescriptor element : array = nd.getMethods()) {
                MethodPermission[] mps;
                EjbDescriptor target = this.descriptor.getEjbByName(element.getEjbName());
                for (MethodPermission mp : mps = nd.getMethodPermissions()) {
                    DOLUtils.getDefaultLogger().fine("Adding mp " + String.valueOf(mp) + " to " + String.valueOf(element) + " for ejb " + element.getEjbName());
                    target.addPermissionedMethod(mp, element);
                }
            }
        } else {
            super.addDescriptor(newDescriptor);
        }
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("module-name".equals(element.getQName())) {
            EjbBundleDescriptorImpl bundleDesc = this.getDescriptor();
            if (bundleDesc.getModuleDescriptor().getDescriptor() instanceof EjbBundleDescriptorImpl) {
                bundleDesc.getModuleDescriptor().setModuleName(value);
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public EjbBundleDescriptorImpl getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new EjbBundleDescriptorImpl();
        }
        return this.descriptor;
    }

    @Override
    protected XMLElement getXMLRootTag() {
        return tag;
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("ejb-client-jar", "setEjbClientJarUri");
        return table;
    }

    @Override
    public Node writeDescriptor(Node parent, EjbBundleDescriptorImpl ejbDesc) {
        Node jarNode = super.writeDescriptor(parent, ejbDesc);
        Element entrepriseBeansNode = EjbBundleNode.appendChild(jarNode, "enterprise-beans");
        for (EjbDescriptor ejb : ejbDesc.getEjbs()) {
            EjbNode subNode;
            if ("Session".equals(ejb.getType())) {
                subNode = new EjbSessionNode();
                ((EjbSessionNode)subNode).writeDescriptor((Node)entrepriseBeansNode, "session", (EjbSessionDescriptor)ejb);
                continue;
            }
            if ("Entity".equals(ejb.getType())) {
                subNode = new EjbEntityNode();
                ((EjbEntityNode)subNode).writeDescriptor((Node)entrepriseBeansNode, "entity", (EjbEntityDescriptor)ejb);
                continue;
            }
            if ("Message-driven".equals(ejb.getType())) {
                subNode = new MessageDrivenBeanNode();
                ((MessageDrivenBeanNode)subNode).writeDescriptor((Node)entrepriseBeansNode, "message-driven", (EjbMessageBeanDescriptor)ejb);
                continue;
            }
            throw new IllegalStateException("Unknow ejb type " + ejb.getType());
        }
        Set<EjbInterceptor> interceptors = ejbDesc.getInterceptors();
        if (!interceptors.isEmpty()) {
            Element interceptorsNode = EjbBundleNode.appendChild(jarNode, "interceptors");
            EjbInterceptorNode interceptorNode = new EjbInterceptorNode();
            for (EjbInterceptor next : interceptors) {
                interceptorNode.writeDescriptor((Node)interceptorsNode, "interceptor", next);
            }
        }
        if (ejbDesc.hasRelationships()) {
            RelationshipsNode.writeRelationships(jarNode, "relationships", ejbDesc);
        }
        this.writeAssemblyDescriptor(jarNode, ejbDesc);
        EjbBundleNode.appendTextChild(jarNode, "ejb-client-jar", ejbDesc.getEjbClientJarUri());
        return jarNode;
    }

    @Override
    public String getDocType() {
        return null;
    }

    @Override
    public String getSystemID() {
        return SCHEMA_ID;
    }

    @Override
    public List<String> getSystemIDs() {
        return SYSTEM_IDS;
    }

    @Override
    public String getSpecVersion() {
        return SPEC_VERSION;
    }

    private void writeAssemblyDescriptor(Node parentNode, EjbBundleDescriptorImpl bundleDescriptor) {
        Element assemblyNode = parentNode.getOwnerDocument().createElement("assembly-descriptor");
        SecurityRoleNode roleNode = new SecurityRoleNode();
        for (Role element : bundleDescriptor.getRoles()) {
            roleNode.writeDescriptor((Node)assemblyNode, "security-role", element);
        }
        HashMap<EjbDescriptor, Vector<MethodDescriptor>> excludedMethodsByEjb = new HashMap<EjbDescriptor, Vector<MethodDescriptor>>();
        MethodPermissionNode mpNode = new MethodPermissionNode();
        for (EjbDescriptor ejbDescriptor : bundleDescriptor.getEjbs()) {
            if (ejbDescriptor instanceof EjbMessageBeanDescriptor) continue;
            Vector<MethodDescriptor> vector = new Vector<MethodDescriptor>();
            this.addMethodPermissions(ejbDescriptor, ejbDescriptor.getPermissionedMethodsByPermission(), vector, mpNode, assemblyNode);
            this.addMethodPermissions(ejbDescriptor, ejbDescriptor.getStyledPermissionedMethodsByPermission(), vector, mpNode, assemblyNode);
            if (vector.isEmpty()) continue;
            excludedMethodsByEjb.put(ejbDescriptor, vector);
        }
        for (EjbDescriptor ejbDescriptor : bundleDescriptor.getEjbs()) {
            ContainerTransactionNode.writeContainerTransactions(assemblyNode, "container-transaction", ejbDescriptor.getName(), ejbDescriptor.getMethodContainerTransactions());
        }
        InterceptorBindingNode ibNode = new InterceptorBindingNode();
        for (EjbDescriptor ejbDescriptor : bundleDescriptor.getEjbs()) {
            if (ejbDescriptor.getInterceptorClasses().isEmpty()) continue;
            ibNode.writeBindings(assemblyNode, ejbDescriptor);
        }
        this.writeMessageDestinations(assemblyNode, bundleDescriptor.getMessageDestinations().iterator());
        if (!excludedMethodsByEjb.isEmpty()) {
            Element element = DeploymentDescriptorNode.appendChild(assemblyNode, "exclude-list");
            for (Map.Entry entry : excludedMethodsByEjb.entrySet()) {
                EjbDescriptor ejbDesc = (EjbDescriptor)entry.getKey();
                Vector excludedMethods = (Vector)entry.getValue();
                MethodPermissionDescriptor mpd = new MethodPermissionDescriptor();
                mpd.addMethodPermission(MethodPermission.getDenyAllMethodPermission());
                mpd.addMethods(excludedMethods);
                mpNode.writeDescriptorInNode(element, mpd, ejbDesc);
            }
        }
        for (EjbApplicationExceptionInfo ejbApplicationExceptionInfo : bundleDescriptor.getApplicationExceptions().values()) {
            EjbApplicationExceptionNode ejbApplicationExceptionNode = new EjbApplicationExceptionNode();
            ejbApplicationExceptionNode.writeDescriptor((Node)assemblyNode, "application-exception", ejbApplicationExceptionInfo);
        }
        if (assemblyNode.hasChildNodes()) {
            parentNode.appendChild(assemblyNode);
        }
    }

    private void addMethodPermissions(EjbDescriptor ejb, Map<MethodPermission, Set<MethodDescriptor>> mpToMethods, Vector<MethodDescriptor> excludedMethods, MethodPermissionNode mpNode, Node assemblyNode) {
        if (mpToMethods == null || mpToMethods.isEmpty()) {
            return;
        }
        for (Map.Entry<MethodPermission, Set<MethodDescriptor>> entry : mpToMethods.entrySet()) {
            MethodPermission mp = entry.getKey();
            if (mp.isExcluded()) {
                Set<MethodDescriptor> methods = entry.getValue();
                excludedMethods.addAll(methods);
                continue;
            }
            MethodPermissionDescriptor mpd = new MethodPermissionDescriptor();
            mpd.addMethodPermission(mp);
            mpd.addMethods((Collection<MethodDescriptor>)mpToMethods.get(mp));
            mpNode.writeDescriptor(assemblyNode, "method-permission", mpd, ejb);
        }
    }
}

