/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Service;

@Service(name="_validateRemoteDirDeployment")
@Supplemental(value="deploy", on=Supplemental.Timing.Before, ifFailure=FailurePolicy.Error)
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="_validateRemoteDirDeployment", description="_validateRemoteDirDeployment")})
@AccessRequired(resource={"domain/applications/application"}, action={"write"})
public class ValidateRemoteDirDeploymentCommand
extends DeployCommandParameters
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ValidateRemoteDirDeploymentCommand.class);
    @Inject
    private ArchiveFactory archiveFactory;
    @Inject
    private ServiceLocator habitat;
    @Inject
    private Deployment deployment;

    @Override
    public void execute(AdminCommandContext context) {
        TargetInfo targetInfo;
        ActionReport report = context.getActionReport();
        Logger logger2 = context.getLogger();
        ReadableArchive archive = this.archive(logger2, report);
        if (archive == null) {
            this.reportSuccess(report);
            return;
        }
        File source = new File(archive.getURI().getSchemeSpecificPart());
        try {
            archive.close();
        }
        catch (IOException ex) {
            report.failure(logger2, ex.getLocalizedMessage(), ex);
        }
        if (!source.isDirectory()) {
            this.reportSuccess(report);
            return;
        }
        if (this.target == null) {
            this.target = this.deployment.getDefaultTarget(this.name, this.origin, this._classicstyle);
        }
        if (!(targetInfo = new TargetInfo(this.target)).containsNonDAS()) {
            this.reportSuccess(report);
            return;
        }
        long checksum = DeploymentUtils.checksum(source);
        ParameterMap paramMap = new ParameterMap();
        paramMap.add("checksum", Long.toString(checksum));
        paramMap.add("DEFAULT", this.path.toURI().getSchemeSpecificPart());
        ActionReport.ExitCode replicateResult = ClusterOperationUtil.replicateCommand("_instanceValidateRemoteDirDeployment", FailurePolicy.Error, FailurePolicy.Ignore, FailurePolicy.Ignore, targetInfo.targetNames(), context, paramMap, this.habitat);
        report.setActionExitCode(replicateResult);
    }

    private ReadableArchive archive(Logger logger2, ActionReport report) {
        try {
            return this.archiveFactory.openArchive(this.path, this);
        }
        catch (IOException e) {
            String msg = localStrings.getLocalString("deploy.errOpeningArtifact", "deploy.errOpeningArtifact", this.path.getAbsolutePath());
            if (this.logReportedErrors.booleanValue()) {
                report.failure(logger2, msg, e);
            } else {
                report.setMessage(msg + this.path.getAbsolutePath() + e.toString());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            return null;
        }
    }

    private void reportSuccess(ActionReport report) {
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        report.setMessage("");
    }

    private static class TargetInfo {
        private boolean containsNonDAS = false;
        private final List<String> targetNames = new ArrayList<String>();

        private TargetInfo(String targetExpr) {
            for (String targetName : targetExpr.split(",")) {
                this.targetNames.add(targetName);
                this.containsNonDAS |= !DeploymentUtils.isDASTarget(targetName);
            }
        }

        private boolean containsNonDAS() {
            return this.containsNonDAS;
        }

        private List<String> targetNames() {
            return this.targetNames;
        }
    }
}

