/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.deployment.admin.DeployCommandSupplementalInfo;
import org.glassfish.deployment.admin.InterceptorNotifier;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class PostStateCommand
implements AdminCommand,
AdminCommandSecurity.Preauthorization,
AdminCommandSecurity.AccessCheckProvider {
    @Inject
    protected ServiceLocator habitat;
    private DeployCommandSupplementalInfo suppInfo;
    private Collection<? extends AccessRequired.AccessCheck> accessChecks;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        this.suppInfo = context.getActionReport().getResultType(DeployCommandSupplementalInfo.class);
        this.accessChecks = this.suppInfo.getAccessChecks();
        return true;
    }

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        return this.accessChecks;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger2 = context.getLogger();
        try {
            logger2.log(Level.INFO, "PostState starting: " + this.getClass().getName());
            if (this.suppInfo == null) {
                throw new IllegalStateException("Internal Error: suppInfo was not set. Insure that it is set properly.");
            }
            ExtendedDeploymentContext dc = this.suppInfo.deploymentContext();
            if (dc == null) {
                return;
            }
            InterceptorNotifier notifier = new InterceptorNotifier(this.habitat, dc);
            try {
                notifier.ensureAfterReported(ExtendedDeploymentContext.Phase.REPLICATION);
                logger2.log(Level.INFO, "PostStateCommand: " + this.getClass().getName() + " finished successfully");
            }
            catch (Exception e) {
                report.failure(logger2, e.getMessage());
                logger2.log(Level.SEVERE, "Error during inner PostState: " + this.getClass().getName(), e);
            }
        }
        catch (Exception e) {
            logger2.log(Level.SEVERE, "Error duirng outer PostState: " + this.getClass().getName(), e);
        }
    }
}

