/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.ResourceAdapterConfig;
import org.glassfish.connectors.config.WorkSecurityMap;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.jvnet.hk2.annotations.Service;

@Service(name="_list-resources")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="_list-resources", description="_list-resources")})
public class ListResources
implements AdminCommand {
    @Inject
    private Applications applications;
    @Param(optional=false, name="appname")
    private String appName;
    @Param(optional=true, name="modulename")
    private String moduleName;
    @Inject
    BindableResourcesHelper bindableResourcesHelper;

    @Override
    public void execute(AdminCommandContext context) {
        Application application;
        Resources appScopedResources;
        if (this.appName != null && !this.isValidApplication(this.appName)) {
            ActionReport report = context.getActionReport();
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            ActionReport.MessagePart messagePart = report.getTopMessagePart();
            messagePart.setMessage("Invalid application [" + this.appName + "]");
            return;
        }
        if (this.moduleName != null && !this.isValidModule(this.appName, this.moduleName)) {
            ActionReport report = context.getActionReport();
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            ActionReport.MessagePart messagePart = report.getTopMessagePart();
            messagePart.setMessage("Invalid module [" + this.moduleName + "] in application [" + this.appName + "]");
            return;
        }
        if (this.appName != null && this.moduleName != null) {
            Application application2 = this.applications.getApplication(this.appName);
            Module module = application2.getModule(this.moduleName);
            Resources moduleScopedResources = module.getResources();
            if (moduleScopedResources != null) {
                ActionReport report = context.getActionReport();
                ActionReport.MessagePart messagePart = report.getTopMessagePart();
                this.generateResourcesList(messagePart, moduleScopedResources.getResources());
            }
        } else if (this.appName != null && (appScopedResources = (application = this.applications.getApplication(this.appName)).getResources()) != null) {
            ActionReport report = context.getActionReport();
            ActionReport.MessagePart messagePart = report.getTopMessagePart();
            this.generateResourcesList(messagePart, appScopedResources.getResources());
        }
    }

    private void generateResourcesList(ActionReport.MessagePart part, List<Resource> resources) {
        HashMap<String, List<String>> list = new HashMap<String, List<String>>();
        for (Resource resource : resources) {
            List<String> typedResources;
            String type2;
            String name;
            if (resource instanceof BindableResource) {
                name = ((BindableResource)resource).getJndiName();
                Object type22 = "";
                String resourceName = this.bindableResourcesHelper.getResourceTypeName((BindableResource)resource);
                type22 = "<" + resourceName + ">";
                List<String> typedResources2 = this.getResourcesByType(list, (String)type22);
                typedResources2.add(name);
                continue;
            }
            if (resource instanceof ResourcePool) {
                name = ((ResourcePool)resource).getName();
                type2 = "";
                if (resource instanceof JdbcConnectionPool) {
                    type2 = "<JdbcConnectionPool>";
                } else if (resource instanceof ConnectorConnectionPool) {
                    type2 = "<ConnectorConnectionPool>";
                }
                typedResources = this.getResourcesByType(list, type2);
                typedResources.add(name);
                continue;
            }
            if (resource instanceof ResourceAdapterConfig) {
                name = ((ResourceAdapterConfig)resource).getResourceAdapterName();
                type2 = "<ResourceAdapterConfig>";
                typedResources = this.getResourcesByType(list, type2);
                typedResources.add(name);
                continue;
            }
            if (!(resource instanceof WorkSecurityMap)) continue;
            name = ((WorkSecurityMap)resource).getName();
            type2 = "<WorkSecurityMap>";
            typedResources = this.getResourcesByType(list, type2);
            typedResources.add(name);
        }
        for (Map.Entry entry : list.entrySet()) {
            String type3 = (String)entry.getKey();
            List values = (List)entry.getValue();
            for (String value : values) {
                ActionReport.MessagePart child = part.addChild();
                child.setMessage("  " + value + "\t" + type3);
                part.addProperty(value, type3);
            }
        }
    }

    private List<String> getResourcesByType(Map<String, List<String>> list, String type2) {
        List<String> typedResources = list.get(type2);
        if (typedResources == null) {
            typedResources = new ArrayList<String>();
            list.put(type2, typedResources);
        }
        return typedResources;
    }

    private boolean isValidApplication(String appName) {
        Application app = this.applications.getApplication(appName);
        return app != null;
    }

    private boolean isValidModule(String appName, String moduleName) {
        Application app = this.applications.getApplication(appName);
        Module module = app.getModule(moduleName);
        return module != null;
    }
}

